/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rychly.gphotos_uploader.gphotos;

import com.google.common.collect.Lists;
import com.google.photos.library.v1.PhotosLibraryClient;
import com.google.photos.library.v1.internal.InternalPhotosLibraryClient;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsResponse;
import com.google.photos.library.v1.proto.NewMediaItemResult;
import com.google.photos.library.v1.upload.UploadMediaItemRequest;
import com.google.photos.library.v1.upload.UploadMediaItemResponse;
import com.google.photos.library.v1.util.NewMediaItemFactory;
import com.google.photos.types.proto.Album;
import com.google.photos.types.proto.MediaItem;
import io.gitlab.rychly.gphotos_uploader.gphotos.MediaFile;
import io.gitlab.rychly.gphotos_uploader.i18n.ResourceBundleFactory;
import io.gitlab.rychly.gphotos_uploader.logger.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class GPhotos {
    public static final int CREATE_MEDIA_ITEMS_BATCH_LIMIT = 50;

    public static Iterable<Album> getAlbums(@NotNull PhotosLibraryClient photosLibraryClient) {
        InternalPhotosLibraryClient.ListAlbumsPagedResponse listAlbumsPagedResponse = photosLibraryClient.listAlbums();
        return listAlbumsPagedResponse.iterateAll();
    }

    public static Iterable<Album> getSharedAlbums(@NotNull PhotosLibraryClient photosLibraryClient) {
        InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse listSharedAlbumsPagedResponse = photosLibraryClient.listSharedAlbums();
        return listSharedAlbumsPagedResponse.iterateAll();
    }

    public static Album getAlbum(@NotNull PhotosLibraryClient photosLibraryClient, String id) {
        return photosLibraryClient.getAlbum(id);
    }

    public static Stream<Album> getAlbumsStreamByTitle(@NotNull PhotosLibraryClient photosLibraryClient, String titleOrRegEx, boolean isRegularExpression) {
        return StreamSupport.stream(GPhotos.getAlbums(photosLibraryClient).spliterator(), false).filter(album -> isRegularExpression ? titleOrRegEx.isEmpty() || album.getTitle().matches(titleOrRegEx) : album.getTitle().equals(titleOrRegEx));
    }

    public static Stream<Album> getSharedAlbumsStreamByTitle(@NotNull PhotosLibraryClient photosLibraryClient, String titleOrRegEx, boolean isRegularExpression) {
        return StreamSupport.stream(GPhotos.getSharedAlbums(photosLibraryClient).spliterator(), false).filter(album -> isRegularExpression ? titleOrRegEx.isEmpty() || album.getTitle().matches(titleOrRegEx) : album.getTitle().equals(titleOrRegEx));
    }

    public static Album getOrCreateAlbum(@NotNull PhotosLibraryClient photosLibraryClient, String title) {
        Optional<Album> album = GPhotos.getAlbumsStreamByTitle(photosLibraryClient, title, false).findFirst();
        return album.orElseGet(() -> photosLibraryClient.createAlbum(title));
    }

    public static Iterable<MediaItem> getMediaItems(@NotNull PhotosLibraryClient photosLibraryClient, @NotNull Album album) {
        InternalPhotosLibraryClient.SearchMediaItemsPagedResponse searchMediaItemsPagedResponse = photosLibraryClient.searchMediaItems(album.getId());
        return searchMediaItemsPagedResponse.iterateAll();
    }

    public static MediaItem getMediaItem(@NotNull PhotosLibraryClient photosLibraryClient, String id) {
        return photosLibraryClient.getMediaItem(id);
    }

    @NotNull
    public static Triple<Collection<MediaItem>, Collection<MediaItem>, Collection<MediaFile>> classifyMediaItemsByFilesAndGetMissingFiles(@NotNull PhotosLibraryClient photosLibraryClient, Album album, @NotNull Stream<MediaFile> files) {
        Map stringMediaFileMap = files.collect(Collectors.toMap(File::getName, mediaFile -> mediaFile, (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate file-names for media files %s and %s", v1, v2));
        }, LinkedHashMap::new));
        Map<Boolean, List<MediaItem>> mediaItemsClassifiedByFiles = StreamSupport.stream(GPhotos.getMediaItems(photosLibraryClient, album).spliterator(), false).collect(Collectors.partitioningBy(mediaItem -> stringMediaFileMap.containsKey(mediaItem.getFilename())));
        for (MediaItem mediaItem2 : mediaItemsClassifiedByFiles.get(true)) {
            stringMediaFileMap.remove(mediaItem2.getFilename());
        }
        return Triple.of((Object)mediaItemsClassifiedByFiles.get(true), (Object)mediaItemsClassifiedByFiles.get(false), stringMediaFileMap.values());
    }

    public static Stream<MediaItem> createMediaItems(@NotNull PhotosLibraryClient photosLibraryClient, @NotNull Album album, @NotNull Collection<MediaFile> files) {
        List newMediaItemList = files.stream().flatMap(mediaFile -> {
            try {
                LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("UploadingFile(%s)", mediaFile.getAbsolutePath()));
                return Stream.of(Pair.of((Object)mediaFile, (Object)GPhotos.uploadMedia(photosLibraryClient, mediaFile)));
            }
            catch (IOException e) {
                LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("SkippingFileUpload(%s,%s)", mediaFile.getAbsolutePath(), e.getMessage()), e);
                return Stream.empty();
            }
        }).flatMap(pair -> {
            MediaFile mediaFile = (MediaFile)pair.getLeft();
            String uploadedContentToken = (String)pair.getRight();
            try {
                return Stream.of(NewMediaItemFactory.createNewMediaItem((String)uploadedContentToken, (String)mediaFile.getName(), (String)mediaFile.generateDescription()));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("SkippingMediaItemCreation(%s,%s)", mediaFile.getAbsolutePath(), e.getMessage()), e);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("CreatingMediaItems(%d)", newMediaItemList.size()));
        LinkedList<Stream<MediaItem>> streamList = new LinkedList<Stream<MediaItem>>();
        for (List chunk : Lists.partition(newMediaItemList, (int)50)) {
            BatchCreateMediaItemsResponse batchCreateMediaItemsResponse = photosLibraryClient.batchCreateMediaItems(album.getId(), chunk);
            Stream<MediaItem> mediaItemStream2 = batchCreateMediaItemsResponse.getNewMediaItemResultsList().stream().filter(newMediaItemResult -> newMediaItemResult.getStatus().getCode() == 0).map(NewMediaItemResult::getMediaItem);
            streamList.add(mediaItemStream2);
        }
        return streamList.stream().flatMap(mediaItemStream -> mediaItemStream);
    }

    @NotNull
    public static String uploadMedia(@NotNull PhotosLibraryClient photosLibraryClient, @NotNull File file) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            UploadMediaItemRequest uploadMediaItemRequest = UploadMediaItemRequest.newBuilder().setMimeType(Files.probeContentType(file.toPath())).setDataFile(randomAccessFile).build();
            UploadMediaItemResponse uploadMediaItemResponse = photosLibraryClient.uploadMediaItem(uploadMediaItemRequest);
            if (uploadMediaItemResponse.getError().isPresent() || !uploadMediaItemResponse.getUploadToken().isPresent()) {
                throw new IOException(ResourceBundleFactory.msg("CannotUploadFile(%s,%s)", file.getAbsolutePath(), uploadMediaItemResponse.getError().toString()));
            }
            String string = (String)uploadMediaItemResponse.getUploadToken().get();
            return string;
        }
    }
}

