/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.util;

import com.google.photos.library.v1.proto.AlbumPosition;

public final class AlbumPositionFactory {
    private AlbumPositionFactory() {
    }

    public static final AlbumPosition createFirstInAlbum() {
        return AlbumPosition.newBuilder().setPosition(AlbumPosition.PositionType.FIRST_IN_ALBUM).build();
    }

    public static final AlbumPosition createLastInAlbum() {
        return AlbumPosition.newBuilder().setPosition(AlbumPosition.PositionType.LAST_IN_ALBUM).build();
    }

    public static final AlbumPosition createAfterMediaItem(String mediaItemId) {
        if (mediaItemId == null || mediaItemId.isEmpty()) {
            throw new IllegalArgumentException("Media item ID cannot be null or empty.");
        }
        return AlbumPosition.newBuilder().setPosition(AlbumPosition.PositionType.AFTER_MEDIA_ITEM).setRelativeMediaItemId(mediaItemId).build();
    }

    public static final AlbumPosition createAfterEnrichmentItem(String enrichmentItemId) {
        if (enrichmentItemId == null || enrichmentItemId.isEmpty()) {
            throw new IllegalArgumentException("Enrichment item ID cannot be null or empty.");
        }
        return AlbumPosition.newBuilder().setPosition(AlbumPosition.PositionType.AFTER_ENRICHMENT_ITEM).setRelativeEnrichmentItemId(enrichmentItemId).build();
    }
}

