/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.upload;

import com.google.api.gax.rpc.ApiException;
import java.util.Optional;

public final class UploadMediaItemResponse {
    private final Optional<String> uploadToken;
    private final Optional<Error> error;

    private UploadMediaItemResponse(Optional<String> uploadToken, Optional<Error> error) {
        this.uploadToken = uploadToken;
        this.error = error;
    }

    public Optional<String> getUploadToken() {
        return this.uploadToken;
    }

    public Optional<Error> getError() {
        return this.error;
    }

    public static final Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> uploadToken;
        private Optional<Error> error;

        private Builder() {
        }

        public Builder setUploadToken(String uploadToken) {
            this.uploadToken = Optional.of(uploadToken);
            this.error = Optional.empty();
            return this;
        }

        public Builder setError(Error error) {
            this.error = Optional.of(error);
            this.uploadToken = Optional.empty();
            return this;
        }

        public UploadMediaItemResponse build() {
            return new UploadMediaItemResponse(this.uploadToken, this.error);
        }
    }

    public static final class Error {
        private final Optional<String> resumeUrl;
        private final ApiException cause;

        private Error(Optional<String> resumeUrl, ApiException cause) {
            this.resumeUrl = resumeUrl;
            this.cause = cause;
        }

        public Optional<String> getResumeUrl() {
            return this.resumeUrl;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public static final Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Optional<String> resumeUrl = Optional.empty();
            private ApiException cause;

            private Builder() {
            }

            public Builder setResumeUrl(Optional<String> resumeUrl) {
                this.resumeUrl = resumeUrl;
                return this;
            }

            public Builder setCause(ApiException cause) {
                this.cause = cause;
                return this;
            }

            public Error build() {
                return new Error(this.resumeUrl, this.cause);
            }
        }
    }
}

