/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.upload;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Optional;

public final class UploadMediaItemRequest {
    private static final int DEFAULT_CHUNK_SIZE = 0xA00000;
    private final Optional<String> fileName;
    private final Optional<String> mimeType;
    private final Optional<String> uploadUrl;
    private final int chunkSize;
    private final RandomAccessFile dataFile;

    private UploadMediaItemRequest(Optional<String> fileName, Optional<String> uploadUrl, int chunkSize, Optional<String> mimeType, RandomAccessFile dataFile) {
        this.fileName = fileName;
        this.uploadUrl = uploadUrl;
        this.chunkSize = chunkSize;
        this.mimeType = mimeType;
        this.dataFile = dataFile;
    }

    public Optional<String> getFileName() {
        return this.fileName;
    }

    public Optional<String> getMimeType() {
        return this.mimeType;
    }

    public Optional<String> getUploadUrl() {
        return this.uploadUrl;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public long getFileSize() throws IOException {
        return this.dataFile.getChannel().size();
    }

    int readData(byte[] bytes) throws IOException {
        return this.dataFile.read(bytes);
    }

    void seekCursor(long offset) throws IOException {
        this.dataFile.seek(offset);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> fileName = Optional.empty();
        private Optional<String> mimeType = Optional.empty();
        private Optional<String> uploadUrl = Optional.empty();
        private int chunkSize = 0xA00000;
        private RandomAccessFile dataFile;

        private Builder() {
        }

        @Deprecated
        public Builder setFileName(String fileName) {
            this.fileName = Optional.of(fileName);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.mimeType = Optional.of(mimeType);
            return this;
        }

        public Builder setUploadUrl(String uploadUrl) {
            this.uploadUrl = Optional.of(uploadUrl);
            return this;
        }

        public Builder setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder setDataFile(RandomAccessFile dataFile) {
            this.dataFile = dataFile;
            return this;
        }

        public UploadMediaItemRequest build() {
            UploadMediaItemRequest uploadMediaItemRequest = new UploadMediaItemRequest(this.fileName, this.uploadUrl, this.chunkSize, this.mimeType, this.dataFile);
            return uploadMediaItemRequest;
        }
    }
}

