/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.upload;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.photos.library.v1.PhotosLibrarySettings;
import com.google.photos.library.v1.upload.PhotosLibraryUploadCallable;
import com.google.photos.library.v1.upload.PhotosLibraryUploadExceptionMappingFn;
import com.google.photos.library.v1.upload.UploadMediaItemRequest;
import com.google.photos.library.v1.upload.UploadMediaItemResponse;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class PhotosLibraryUploadUnaryCallable
extends UnaryCallable<UploadMediaItemRequest, UploadMediaItemResponse> {
    private final ClientContext clientContext;
    private final PhotosLibrarySettings photosLibrarySettings;

    PhotosLibraryUploadUnaryCallable(ClientContext clientContext, PhotosLibrarySettings photosLibrarySettings) {
        this.clientContext = clientContext;
        this.photosLibrarySettings = photosLibrarySettings;
    }

    public ApiFuture<UploadMediaItemResponse> futureCall(UploadMediaItemRequest request, ApiCallContext unusedContext) {
        PhotosLibraryUploadCallable uploadCallable = new PhotosLibraryUploadCallable(request, this.clientContext, this.photosLibrarySettings);
        return ApiFutures.catching((ApiFuture)PhotosLibraryUploadApiFuture.create(uploadCallable, this.clientContext), Throwable.class, (ApiFunction)new PhotosLibraryUploadExceptionMappingFn(uploadCallable.getAtomicResumeUrl()));
    }

    private static final class PhotosLibraryUploadApiFuture
    implements ApiFuture<UploadMediaItemResponse> {
        private final ListenableFutureTask<UploadMediaItemResponse> futureTask;

        private PhotosLibraryUploadApiFuture(ListenableFutureTask<UploadMediaItemResponse> futureTask) {
            this.futureTask = futureTask;
        }

        public static final PhotosLibraryUploadApiFuture create(PhotosLibraryUploadCallable uploadCallable, ClientContext clientContext) {
            PhotosLibraryUploadApiFuture future = new PhotosLibraryUploadApiFuture((ListenableFutureTask<UploadMediaItemResponse>)ListenableFutureTask.create((Callable)uploadCallable));
            clientContext.getExecutor().execute((Runnable)future.futureTask);
            return future;
        }

        public void addListener(Runnable listener, Executor executor) {
            this.futureTask.addListener(listener, executor);
        }

        public boolean cancel(boolean b) {
            return this.futureTask.cancel(b);
        }

        public boolean isCancelled() {
            return this.futureTask.isCancelled();
        }

        public boolean isDone() {
            return this.futureTask.isDone();
        }

        public UploadMediaItemResponse get() throws InterruptedException, ExecutionException {
            return (UploadMediaItemResponse)this.futureTask.get();
        }

        public UploadMediaItemResponse get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return (UploadMediaItemResponse)this.futureTask.get(l, timeUnit);
        }
    }
}

