/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.upload;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.photos.library.v1.upload.UploadMediaItemResponse;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.http.client.HttpResponseException;

final class PhotosLibraryUploadExceptionMappingFn
implements ApiFunction<Throwable, UploadMediaItemResponse> {
    private final AtomicReference<String> atomicResumeUrl;

    PhotosLibraryUploadExceptionMappingFn(AtomicReference<String> atomicResumeUrl) {
        this.atomicResumeUrl = atomicResumeUrl;
    }

    @Nullable
    public UploadMediaItemResponse apply(@Nullable Throwable input) {
        Optional<String> resumeUrl = Optional.ofNullable(this.atomicResumeUrl.get());
        return UploadMediaItemResponse.newBuilder().setError(UploadMediaItemResponse.Error.newBuilder().setResumeUrl(resumeUrl).setCause(new ApiException(input, PhotosLibraryUploadExceptionMappingFn.getStatusCode(input), resumeUrl.isPresent())).build()).build();
    }

    private static StatusCode getStatusCode(@Nullable Throwable input) {
        if (input == null) {
            return GrpcStatusCode.of((Status.Code)Status.Code.UNKNOWN);
        }
        if (input instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)input;
            return PhotosLibraryUploadExceptionMappingFn.httpCodeToStatusCode(httpResponseException.getStatusCode());
        }
        return GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT);
    }

    private static StatusCode httpCodeToStatusCode(int httpCode) {
        switch (httpCode) {
            case 200: {
                return GrpcStatusCode.of((Status.Code)Status.Code.OK);
            }
            case 409: {
                return GrpcStatusCode.of((Status.Code)Status.Code.ABORTED);
            }
            case 503: {
                return GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE);
            }
            case 400: {
                return GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT);
            }
            case 412: {
                return GrpcStatusCode.of((Status.Code)Status.Code.FAILED_PRECONDITION);
            }
            case 413: {
                return GrpcStatusCode.of((Status.Code)Status.Code.OUT_OF_RANGE);
            }
            case 500: {
                return GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL);
            }
        }
        return GrpcStatusCode.of((Status.Code)Status.Code.UNKNOWN);
    }
}

