/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.internal.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.photos.library.v1.internal.InternalPhotosLibraryClient;
import com.google.photos.library.v1.internal.stub.GrpcPhotosLibraryStub;
import com.google.photos.library.v1.internal.stub.PhotosLibraryStub;
import com.google.photos.library.v1.proto.AddEnrichmentToAlbumRequest;
import com.google.photos.library.v1.proto.AddEnrichmentToAlbumResponse;
import com.google.photos.library.v1.proto.BatchAddMediaItemsToAlbumRequest;
import com.google.photos.library.v1.proto.BatchAddMediaItemsToAlbumResponse;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsRequest;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsResponse;
import com.google.photos.library.v1.proto.BatchGetMediaItemsRequest;
import com.google.photos.library.v1.proto.BatchGetMediaItemsResponse;
import com.google.photos.library.v1.proto.BatchRemoveMediaItemsFromAlbumRequest;
import com.google.photos.library.v1.proto.BatchRemoveMediaItemsFromAlbumResponse;
import com.google.photos.library.v1.proto.CreateAlbumRequest;
import com.google.photos.library.v1.proto.GetAlbumRequest;
import com.google.photos.library.v1.proto.GetMediaItemRequest;
import com.google.photos.library.v1.proto.GetSharedAlbumRequest;
import com.google.photos.library.v1.proto.JoinSharedAlbumRequest;
import com.google.photos.library.v1.proto.JoinSharedAlbumResponse;
import com.google.photos.library.v1.proto.LeaveSharedAlbumRequest;
import com.google.photos.library.v1.proto.LeaveSharedAlbumResponse;
import com.google.photos.library.v1.proto.ListAlbumsRequest;
import com.google.photos.library.v1.proto.ListAlbumsResponse;
import com.google.photos.library.v1.proto.ListMediaItemsRequest;
import com.google.photos.library.v1.proto.ListMediaItemsResponse;
import com.google.photos.library.v1.proto.ListSharedAlbumsRequest;
import com.google.photos.library.v1.proto.ListSharedAlbumsResponse;
import com.google.photos.library.v1.proto.SearchMediaItemsRequest;
import com.google.photos.library.v1.proto.SearchMediaItemsResponse;
import com.google.photos.library.v1.proto.ShareAlbumRequest;
import com.google.photos.library.v1.proto.ShareAlbumResponse;
import com.google.photos.library.v1.proto.UnshareAlbumRequest;
import com.google.photos.library.v1.proto.UnshareAlbumResponse;
import com.google.photos.library.v1.proto.UpdateAlbumRequest;
import com.google.photos.library.v1.proto.UpdateMediaItemRequest;
import com.google.photos.types.proto.Album;
import com.google.photos.types.proto.MediaItem;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class PhotosLibraryStubSettings
extends StubSettings<PhotosLibraryStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/photoslibrary").add((Object)"https://www.googleapis.com/auth/photoslibrary.appendonly").add((Object)"https://www.googleapis.com/auth/photoslibrary.readonly").add((Object)"https://www.googleapis.com/auth/photoslibrary.readonly.appcreateddata").add((Object)"https://www.googleapis.com/auth/photoslibrary.sharing").build();
    private final UnaryCallSettings<CreateAlbumRequest, Album> createAlbumSettings;
    private final UnaryCallSettings<BatchCreateMediaItemsRequest, BatchCreateMediaItemsResponse> batchCreateMediaItemsSettings;
    private final UnaryCallSettings<BatchAddMediaItemsToAlbumRequest, BatchAddMediaItemsToAlbumResponse> batchAddMediaItemsToAlbumSettings;
    private final PagedCallSettings<SearchMediaItemsRequest, SearchMediaItemsResponse, InternalPhotosLibraryClient.SearchMediaItemsPagedResponse> searchMediaItemsSettings;
    private final PagedCallSettings<ListMediaItemsRequest, ListMediaItemsResponse, InternalPhotosLibraryClient.ListMediaItemsPagedResponse> listMediaItemsSettings;
    private final UnaryCallSettings<GetMediaItemRequest, MediaItem> getMediaItemSettings;
    private final UnaryCallSettings<BatchGetMediaItemsRequest, BatchGetMediaItemsResponse> batchGetMediaItemsSettings;
    private final PagedCallSettings<ListAlbumsRequest, ListAlbumsResponse, InternalPhotosLibraryClient.ListAlbumsPagedResponse> listAlbumsSettings;
    private final UnaryCallSettings<GetAlbumRequest, Album> getAlbumSettings;
    private final UnaryCallSettings<GetSharedAlbumRequest, Album> getSharedAlbumSettings;
    private final UnaryCallSettings<AddEnrichmentToAlbumRequest, AddEnrichmentToAlbumResponse> addEnrichmentToAlbumSettings;
    private final UnaryCallSettings<JoinSharedAlbumRequest, JoinSharedAlbumResponse> joinSharedAlbumSettings;
    private final UnaryCallSettings<LeaveSharedAlbumRequest, LeaveSharedAlbumResponse> leaveSharedAlbumSettings;
    private final UnaryCallSettings<ShareAlbumRequest, ShareAlbumResponse> shareAlbumSettings;
    private final PagedCallSettings<ListSharedAlbumsRequest, ListSharedAlbumsResponse, InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse> listSharedAlbumsSettings;
    private final UnaryCallSettings<UnshareAlbumRequest, UnshareAlbumResponse> unshareAlbumSettings;
    private final UnaryCallSettings<BatchRemoveMediaItemsFromAlbumRequest, BatchRemoveMediaItemsFromAlbumResponse> batchRemoveMediaItemsFromAlbumSettings;
    private final UnaryCallSettings<UpdateAlbumRequest, Album> updateAlbumSettings;
    private final UnaryCallSettings<UpdateMediaItemRequest, MediaItem> updateMediaItemSettings;
    private static final PagedListDescriptor<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem> SEARCH_MEDIA_ITEMS_PAGE_STR_DESC = new PagedListDescriptor<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem>(){

        public String emptyToken() {
            return "";
        }

        public SearchMediaItemsRequest injectToken(SearchMediaItemsRequest payload, String token) {
            return SearchMediaItemsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public SearchMediaItemsRequest injectPageSize(SearchMediaItemsRequest payload, int pageSize) {
            return SearchMediaItemsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchMediaItemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchMediaItemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MediaItem> extractResources(SearchMediaItemsResponse payload) {
            return payload.getMediaItemsList() != null ? payload.getMediaItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem> LIST_MEDIA_ITEMS_PAGE_STR_DESC = new PagedListDescriptor<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem>(){

        public String emptyToken() {
            return "";
        }

        public ListMediaItemsRequest injectToken(ListMediaItemsRequest payload, String token) {
            return ListMediaItemsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListMediaItemsRequest injectPageSize(ListMediaItemsRequest payload, int pageSize) {
            return ListMediaItemsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMediaItemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMediaItemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MediaItem> extractResources(ListMediaItemsResponse payload) {
            return payload.getMediaItemsList() != null ? payload.getMediaItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListAlbumsRequest, ListAlbumsResponse, Album> LIST_ALBUMS_PAGE_STR_DESC = new PagedListDescriptor<ListAlbumsRequest, ListAlbumsResponse, Album>(){

        public String emptyToken() {
            return "";
        }

        public ListAlbumsRequest injectToken(ListAlbumsRequest payload, String token) {
            return ListAlbumsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListAlbumsRequest injectPageSize(ListAlbumsRequest payload, int pageSize) {
            return ListAlbumsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAlbumsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAlbumsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Album> extractResources(ListAlbumsResponse payload) {
            return payload.getAlbumsList() != null ? payload.getAlbumsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album> LIST_SHARED_ALBUMS_PAGE_STR_DESC = new PagedListDescriptor<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album>(){

        public String emptyToken() {
            return "";
        }

        public ListSharedAlbumsRequest injectToken(ListSharedAlbumsRequest payload, String token) {
            return ListSharedAlbumsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListSharedAlbumsRequest injectPageSize(ListSharedAlbumsRequest payload, int pageSize) {
            return ListSharedAlbumsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSharedAlbumsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSharedAlbumsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Album> extractResources(ListSharedAlbumsResponse payload) {
            return payload.getSharedAlbumsList() != null ? payload.getSharedAlbumsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<SearchMediaItemsRequest, SearchMediaItemsResponse, InternalPhotosLibraryClient.SearchMediaItemsPagedResponse> SEARCH_MEDIA_ITEMS_PAGE_STR_FACT = new PagedListResponseFactory<SearchMediaItemsRequest, SearchMediaItemsResponse, InternalPhotosLibraryClient.SearchMediaItemsPagedResponse>(){

        public ApiFuture<InternalPhotosLibraryClient.SearchMediaItemsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchMediaItemsRequest, SearchMediaItemsResponse> callable, SearchMediaItemsRequest request, ApiCallContext context, ApiFuture<SearchMediaItemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_MEDIA_ITEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InternalPhotosLibraryClient.SearchMediaItemsPagedResponse.createAsync((PageContext<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMediaItemsRequest, ListMediaItemsResponse, InternalPhotosLibraryClient.ListMediaItemsPagedResponse> LIST_MEDIA_ITEMS_PAGE_STR_FACT = new PagedListResponseFactory<ListMediaItemsRequest, ListMediaItemsResponse, InternalPhotosLibraryClient.ListMediaItemsPagedResponse>(){

        public ApiFuture<InternalPhotosLibraryClient.ListMediaItemsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMediaItemsRequest, ListMediaItemsResponse> callable, ListMediaItemsRequest request, ApiCallContext context, ApiFuture<ListMediaItemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MEDIA_ITEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InternalPhotosLibraryClient.ListMediaItemsPagedResponse.createAsync((PageContext<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAlbumsRequest, ListAlbumsResponse, InternalPhotosLibraryClient.ListAlbumsPagedResponse> LIST_ALBUMS_PAGE_STR_FACT = new PagedListResponseFactory<ListAlbumsRequest, ListAlbumsResponse, InternalPhotosLibraryClient.ListAlbumsPagedResponse>(){

        public ApiFuture<InternalPhotosLibraryClient.ListAlbumsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAlbumsRequest, ListAlbumsResponse> callable, ListAlbumsRequest request, ApiCallContext context, ApiFuture<ListAlbumsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ALBUMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InternalPhotosLibraryClient.ListAlbumsPagedResponse.createAsync((PageContext<ListAlbumsRequest, ListAlbumsResponse, Album>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSharedAlbumsRequest, ListSharedAlbumsResponse, InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse> LIST_SHARED_ALBUMS_PAGE_STR_FACT = new PagedListResponseFactory<ListSharedAlbumsRequest, ListSharedAlbumsResponse, InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse>(){

        public ApiFuture<InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSharedAlbumsRequest, ListSharedAlbumsResponse> callable, ListSharedAlbumsRequest request, ApiCallContext context, ApiFuture<ListSharedAlbumsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SHARED_ALBUMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse.createAsync((PageContext<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAlbumRequest, Album> createAlbumSettings() {
        return this.createAlbumSettings;
    }

    public UnaryCallSettings<BatchCreateMediaItemsRequest, BatchCreateMediaItemsResponse> batchCreateMediaItemsSettings() {
        return this.batchCreateMediaItemsSettings;
    }

    public UnaryCallSettings<BatchAddMediaItemsToAlbumRequest, BatchAddMediaItemsToAlbumResponse> batchAddMediaItemsToAlbumSettings() {
        return this.batchAddMediaItemsToAlbumSettings;
    }

    public PagedCallSettings<SearchMediaItemsRequest, SearchMediaItemsResponse, InternalPhotosLibraryClient.SearchMediaItemsPagedResponse> searchMediaItemsSettings() {
        return this.searchMediaItemsSettings;
    }

    public PagedCallSettings<ListMediaItemsRequest, ListMediaItemsResponse, InternalPhotosLibraryClient.ListMediaItemsPagedResponse> listMediaItemsSettings() {
        return this.listMediaItemsSettings;
    }

    public UnaryCallSettings<GetMediaItemRequest, MediaItem> getMediaItemSettings() {
        return this.getMediaItemSettings;
    }

    public UnaryCallSettings<BatchGetMediaItemsRequest, BatchGetMediaItemsResponse> batchGetMediaItemsSettings() {
        return this.batchGetMediaItemsSettings;
    }

    public PagedCallSettings<ListAlbumsRequest, ListAlbumsResponse, InternalPhotosLibraryClient.ListAlbumsPagedResponse> listAlbumsSettings() {
        return this.listAlbumsSettings;
    }

    public UnaryCallSettings<GetAlbumRequest, Album> getAlbumSettings() {
        return this.getAlbumSettings;
    }

    public UnaryCallSettings<GetSharedAlbumRequest, Album> getSharedAlbumSettings() {
        return this.getSharedAlbumSettings;
    }

    public UnaryCallSettings<AddEnrichmentToAlbumRequest, AddEnrichmentToAlbumResponse> addEnrichmentToAlbumSettings() {
        return this.addEnrichmentToAlbumSettings;
    }

    public UnaryCallSettings<JoinSharedAlbumRequest, JoinSharedAlbumResponse> joinSharedAlbumSettings() {
        return this.joinSharedAlbumSettings;
    }

    public UnaryCallSettings<LeaveSharedAlbumRequest, LeaveSharedAlbumResponse> leaveSharedAlbumSettings() {
        return this.leaveSharedAlbumSettings;
    }

    public UnaryCallSettings<ShareAlbumRequest, ShareAlbumResponse> shareAlbumSettings() {
        return this.shareAlbumSettings;
    }

    public PagedCallSettings<ListSharedAlbumsRequest, ListSharedAlbumsResponse, InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse> listSharedAlbumsSettings() {
        return this.listSharedAlbumsSettings;
    }

    public UnaryCallSettings<UnshareAlbumRequest, UnshareAlbumResponse> unshareAlbumSettings() {
        return this.unshareAlbumSettings;
    }

    public UnaryCallSettings<BatchRemoveMediaItemsFromAlbumRequest, BatchRemoveMediaItemsFromAlbumResponse> batchRemoveMediaItemsFromAlbumSettings() {
        return this.batchRemoveMediaItemsFromAlbumSettings;
    }

    public UnaryCallSettings<UpdateAlbumRequest, Album> updateAlbumSettings() {
        return this.updateAlbumSettings;
    }

    public UnaryCallSettings<UpdateMediaItemRequest, MediaItem> updateMediaItemSettings() {
        return this.updateMediaItemSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PhotosLibraryStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPhotosLibraryStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "photoslibrary.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PhotosLibraryStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PhotosLibraryStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PhotosLibraryStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAlbumSettings = settingsBuilder.createAlbumSettings().build();
        this.batchCreateMediaItemsSettings = settingsBuilder.batchCreateMediaItemsSettings().build();
        this.batchAddMediaItemsToAlbumSettings = settingsBuilder.batchAddMediaItemsToAlbumSettings().build();
        this.searchMediaItemsSettings = settingsBuilder.searchMediaItemsSettings().build();
        this.listMediaItemsSettings = settingsBuilder.listMediaItemsSettings().build();
        this.getMediaItemSettings = settingsBuilder.getMediaItemSettings().build();
        this.batchGetMediaItemsSettings = settingsBuilder.batchGetMediaItemsSettings().build();
        this.listAlbumsSettings = settingsBuilder.listAlbumsSettings().build();
        this.getAlbumSettings = settingsBuilder.getAlbumSettings().build();
        this.getSharedAlbumSettings = settingsBuilder.getSharedAlbumSettings().build();
        this.addEnrichmentToAlbumSettings = settingsBuilder.addEnrichmentToAlbumSettings().build();
        this.joinSharedAlbumSettings = settingsBuilder.joinSharedAlbumSettings().build();
        this.leaveSharedAlbumSettings = settingsBuilder.leaveSharedAlbumSettings().build();
        this.shareAlbumSettings = settingsBuilder.shareAlbumSettings().build();
        this.listSharedAlbumsSettings = settingsBuilder.listSharedAlbumsSettings().build();
        this.unshareAlbumSettings = settingsBuilder.unshareAlbumSettings().build();
        this.batchRemoveMediaItemsFromAlbumSettings = settingsBuilder.batchRemoveMediaItemsFromAlbumSettings().build();
        this.updateAlbumSettings = settingsBuilder.updateAlbumSettings().build();
        this.updateMediaItemSettings = settingsBuilder.updateMediaItemSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PhotosLibraryStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAlbumRequest, Album> createAlbumSettings;
        private final UnaryCallSettings.Builder<BatchCreateMediaItemsRequest, BatchCreateMediaItemsResponse> batchCreateMediaItemsSettings;
        private final UnaryCallSettings.Builder<BatchAddMediaItemsToAlbumRequest, BatchAddMediaItemsToAlbumResponse> batchAddMediaItemsToAlbumSettings;
        private final PagedCallSettings.Builder<SearchMediaItemsRequest, SearchMediaItemsResponse, InternalPhotosLibraryClient.SearchMediaItemsPagedResponse> searchMediaItemsSettings;
        private final PagedCallSettings.Builder<ListMediaItemsRequest, ListMediaItemsResponse, InternalPhotosLibraryClient.ListMediaItemsPagedResponse> listMediaItemsSettings;
        private final UnaryCallSettings.Builder<GetMediaItemRequest, MediaItem> getMediaItemSettings;
        private final UnaryCallSettings.Builder<BatchGetMediaItemsRequest, BatchGetMediaItemsResponse> batchGetMediaItemsSettings;
        private final PagedCallSettings.Builder<ListAlbumsRequest, ListAlbumsResponse, InternalPhotosLibraryClient.ListAlbumsPagedResponse> listAlbumsSettings;
        private final UnaryCallSettings.Builder<GetAlbumRequest, Album> getAlbumSettings;
        private final UnaryCallSettings.Builder<GetSharedAlbumRequest, Album> getSharedAlbumSettings;
        private final UnaryCallSettings.Builder<AddEnrichmentToAlbumRequest, AddEnrichmentToAlbumResponse> addEnrichmentToAlbumSettings;
        private final UnaryCallSettings.Builder<JoinSharedAlbumRequest, JoinSharedAlbumResponse> joinSharedAlbumSettings;
        private final UnaryCallSettings.Builder<LeaveSharedAlbumRequest, LeaveSharedAlbumResponse> leaveSharedAlbumSettings;
        private final UnaryCallSettings.Builder<ShareAlbumRequest, ShareAlbumResponse> shareAlbumSettings;
        private final PagedCallSettings.Builder<ListSharedAlbumsRequest, ListSharedAlbumsResponse, InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse> listSharedAlbumsSettings;
        private final UnaryCallSettings.Builder<UnshareAlbumRequest, UnshareAlbumResponse> unshareAlbumSettings;
        private final UnaryCallSettings.Builder<BatchRemoveMediaItemsFromAlbumRequest, BatchRemoveMediaItemsFromAlbumResponse> batchRemoveMediaItemsFromAlbumSettings;
        private final UnaryCallSettings.Builder<UpdateAlbumRequest, Album> updateAlbumSettings;
        private final UnaryCallSettings.Builder<UpdateMediaItemRequest, MediaItem> updateMediaItemSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateMediaItemsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchAddMediaItemsToAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchMediaItemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_MEDIA_ITEMS_PAGE_STR_FACT);
            this.listMediaItemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MEDIA_ITEMS_PAGE_STR_FACT);
            this.getMediaItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchGetMediaItemsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAlbumsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ALBUMS_PAGE_STR_FACT);
            this.getAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSharedAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addEnrichmentToAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.joinSharedAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.leaveSharedAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.shareAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSharedAlbumsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SHARED_ALBUMS_PAGE_STR_FACT);
            this.unshareAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchRemoveMediaItemsFromAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAlbumSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMediaItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAlbumSettings, this.batchCreateMediaItemsSettings, this.batchAddMediaItemsToAlbumSettings, this.searchMediaItemsSettings, this.listMediaItemsSettings, this.getMediaItemSettings, this.batchGetMediaItemsSettings, this.listAlbumsSettings, this.getAlbumSettings, this.getSharedAlbumSettings, this.addEnrichmentToAlbumSettings, this.joinSharedAlbumSettings, (Object[])new UnaryCallSettings.Builder[]{this.leaveSharedAlbumSettings, this.shareAlbumSettings, this.listSharedAlbumsSettings, this.unshareAlbumSettings, this.batchRemoveMediaItemsFromAlbumSettings, this.updateAlbumSettings, this.updateMediaItemSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PhotosLibraryStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PhotosLibraryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PhotosLibraryStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PhotosLibraryStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchCreateMediaItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchAddMediaItemsToAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.searchMediaItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listMediaItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getMediaItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchGetMediaItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listAlbumsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSharedAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.addEnrichmentToAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.joinSharedAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.leaveSharedAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.shareAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSharedAlbumsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.unshareAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchRemoveMediaItemsFromAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateAlbumSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateMediaItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(PhotosLibraryStubSettings settings) {
            super((StubSettings)settings);
            this.createAlbumSettings = settings.createAlbumSettings.toBuilder();
            this.batchCreateMediaItemsSettings = settings.batchCreateMediaItemsSettings.toBuilder();
            this.batchAddMediaItemsToAlbumSettings = settings.batchAddMediaItemsToAlbumSettings.toBuilder();
            this.searchMediaItemsSettings = settings.searchMediaItemsSettings.toBuilder();
            this.listMediaItemsSettings = settings.listMediaItemsSettings.toBuilder();
            this.getMediaItemSettings = settings.getMediaItemSettings.toBuilder();
            this.batchGetMediaItemsSettings = settings.batchGetMediaItemsSettings.toBuilder();
            this.listAlbumsSettings = settings.listAlbumsSettings.toBuilder();
            this.getAlbumSettings = settings.getAlbumSettings.toBuilder();
            this.getSharedAlbumSettings = settings.getSharedAlbumSettings.toBuilder();
            this.addEnrichmentToAlbumSettings = settings.addEnrichmentToAlbumSettings.toBuilder();
            this.joinSharedAlbumSettings = settings.joinSharedAlbumSettings.toBuilder();
            this.leaveSharedAlbumSettings = settings.leaveSharedAlbumSettings.toBuilder();
            this.shareAlbumSettings = settings.shareAlbumSettings.toBuilder();
            this.listSharedAlbumsSettings = settings.listSharedAlbumsSettings.toBuilder();
            this.unshareAlbumSettings = settings.unshareAlbumSettings.toBuilder();
            this.batchRemoveMediaItemsFromAlbumSettings = settings.batchRemoveMediaItemsFromAlbumSettings.toBuilder();
            this.updateAlbumSettings = settings.updateAlbumSettings.toBuilder();
            this.updateMediaItemSettings = settings.updateMediaItemSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAlbumSettings, this.batchCreateMediaItemsSettings, this.batchAddMediaItemsToAlbumSettings, this.searchMediaItemsSettings, this.listMediaItemsSettings, this.getMediaItemSettings, this.batchGetMediaItemsSettings, this.listAlbumsSettings, this.getAlbumSettings, this.getSharedAlbumSettings, this.addEnrichmentToAlbumSettings, this.joinSharedAlbumSettings, (Object[])new UnaryCallSettings.Builder[]{this.leaveSharedAlbumSettings, this.shareAlbumSettings, this.listSharedAlbumsSettings, this.unshareAlbumSettings, this.batchRemoveMediaItemsFromAlbumSettings, this.updateAlbumSettings, this.updateMediaItemSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAlbumRequest, Album> createAlbumSettings() {
            return this.createAlbumSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateMediaItemsRequest, BatchCreateMediaItemsResponse> batchCreateMediaItemsSettings() {
            return this.batchCreateMediaItemsSettings;
        }

        public UnaryCallSettings.Builder<BatchAddMediaItemsToAlbumRequest, BatchAddMediaItemsToAlbumResponse> batchAddMediaItemsToAlbumSettings() {
            return this.batchAddMediaItemsToAlbumSettings;
        }

        public PagedCallSettings.Builder<SearchMediaItemsRequest, SearchMediaItemsResponse, InternalPhotosLibraryClient.SearchMediaItemsPagedResponse> searchMediaItemsSettings() {
            return this.searchMediaItemsSettings;
        }

        public PagedCallSettings.Builder<ListMediaItemsRequest, ListMediaItemsResponse, InternalPhotosLibraryClient.ListMediaItemsPagedResponse> listMediaItemsSettings() {
            return this.listMediaItemsSettings;
        }

        public UnaryCallSettings.Builder<GetMediaItemRequest, MediaItem> getMediaItemSettings() {
            return this.getMediaItemSettings;
        }

        public UnaryCallSettings.Builder<BatchGetMediaItemsRequest, BatchGetMediaItemsResponse> batchGetMediaItemsSettings() {
            return this.batchGetMediaItemsSettings;
        }

        public PagedCallSettings.Builder<ListAlbumsRequest, ListAlbumsResponse, InternalPhotosLibraryClient.ListAlbumsPagedResponse> listAlbumsSettings() {
            return this.listAlbumsSettings;
        }

        public UnaryCallSettings.Builder<GetAlbumRequest, Album> getAlbumSettings() {
            return this.getAlbumSettings;
        }

        public UnaryCallSettings.Builder<GetSharedAlbumRequest, Album> getSharedAlbumSettings() {
            return this.getSharedAlbumSettings;
        }

        public UnaryCallSettings.Builder<AddEnrichmentToAlbumRequest, AddEnrichmentToAlbumResponse> addEnrichmentToAlbumSettings() {
            return this.addEnrichmentToAlbumSettings;
        }

        public UnaryCallSettings.Builder<JoinSharedAlbumRequest, JoinSharedAlbumResponse> joinSharedAlbumSettings() {
            return this.joinSharedAlbumSettings;
        }

        public UnaryCallSettings.Builder<LeaveSharedAlbumRequest, LeaveSharedAlbumResponse> leaveSharedAlbumSettings() {
            return this.leaveSharedAlbumSettings;
        }

        public UnaryCallSettings.Builder<ShareAlbumRequest, ShareAlbumResponse> shareAlbumSettings() {
            return this.shareAlbumSettings;
        }

        public PagedCallSettings.Builder<ListSharedAlbumsRequest, ListSharedAlbumsResponse, InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse> listSharedAlbumsSettings() {
            return this.listSharedAlbumsSettings;
        }

        public UnaryCallSettings.Builder<UnshareAlbumRequest, UnshareAlbumResponse> unshareAlbumSettings() {
            return this.unshareAlbumSettings;
        }

        public UnaryCallSettings.Builder<BatchRemoveMediaItemsFromAlbumRequest, BatchRemoveMediaItemsFromAlbumResponse> batchRemoveMediaItemsFromAlbumSettings() {
            return this.batchRemoveMediaItemsFromAlbumSettings;
        }

        public UnaryCallSettings.Builder<UpdateAlbumRequest, Album> updateAlbumSettings() {
            return this.updateAlbumSettings;
        }

        public UnaryCallSettings.Builder<UpdateMediaItemRequest, MediaItem> updateMediaItemSettings() {
            return this.updateMediaItemSettings;
        }

        public PhotosLibraryStubSettings build() throws IOException {
            return new PhotosLibraryStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

