/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1.internal;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.photos.library.v1.internal.InternalPhotosLibrarySettings;
import com.google.photos.library.v1.internal.stub.PhotosLibraryStub;
import com.google.photos.library.v1.internal.stub.PhotosLibraryStubSettings;
import com.google.photos.library.v1.proto.AddEnrichmentToAlbumRequest;
import com.google.photos.library.v1.proto.AddEnrichmentToAlbumResponse;
import com.google.photos.library.v1.proto.AlbumPosition;
import com.google.photos.library.v1.proto.BatchAddMediaItemsToAlbumRequest;
import com.google.photos.library.v1.proto.BatchAddMediaItemsToAlbumResponse;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsRequest;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsResponse;
import com.google.photos.library.v1.proto.BatchGetMediaItemsRequest;
import com.google.photos.library.v1.proto.BatchGetMediaItemsResponse;
import com.google.photos.library.v1.proto.BatchRemoveMediaItemsFromAlbumRequest;
import com.google.photos.library.v1.proto.BatchRemoveMediaItemsFromAlbumResponse;
import com.google.photos.library.v1.proto.CreateAlbumRequest;
import com.google.photos.library.v1.proto.Filters;
import com.google.photos.library.v1.proto.GetAlbumRequest;
import com.google.photos.library.v1.proto.GetMediaItemRequest;
import com.google.photos.library.v1.proto.GetSharedAlbumRequest;
import com.google.photos.library.v1.proto.JoinSharedAlbumRequest;
import com.google.photos.library.v1.proto.JoinSharedAlbumResponse;
import com.google.photos.library.v1.proto.LeaveSharedAlbumRequest;
import com.google.photos.library.v1.proto.LeaveSharedAlbumResponse;
import com.google.photos.library.v1.proto.ListAlbumsRequest;
import com.google.photos.library.v1.proto.ListAlbumsResponse;
import com.google.photos.library.v1.proto.ListMediaItemsRequest;
import com.google.photos.library.v1.proto.ListMediaItemsResponse;
import com.google.photos.library.v1.proto.ListSharedAlbumsRequest;
import com.google.photos.library.v1.proto.ListSharedAlbumsResponse;
import com.google.photos.library.v1.proto.NewEnrichmentItem;
import com.google.photos.library.v1.proto.NewMediaItem;
import com.google.photos.library.v1.proto.SearchMediaItemsRequest;
import com.google.photos.library.v1.proto.SearchMediaItemsResponse;
import com.google.photos.library.v1.proto.ShareAlbumRequest;
import com.google.photos.library.v1.proto.ShareAlbumResponse;
import com.google.photos.library.v1.proto.UnshareAlbumRequest;
import com.google.photos.library.v1.proto.UnshareAlbumResponse;
import com.google.photos.library.v1.proto.UpdateAlbumRequest;
import com.google.photos.library.v1.proto.UpdateMediaItemRequest;
import com.google.photos.types.proto.Album;
import com.google.photos.types.proto.MediaItem;
import com.google.photos.types.proto.SharedAlbumOptions;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InternalPhotosLibraryClient
implements BackgroundResource {
    private final InternalPhotosLibrarySettings settings;
    private final PhotosLibraryStub stub;

    public static final InternalPhotosLibraryClient create() throws IOException {
        return InternalPhotosLibraryClient.create(InternalPhotosLibrarySettings.newBuilder().build());
    }

    public static final InternalPhotosLibraryClient create(InternalPhotosLibrarySettings settings) throws IOException {
        return new InternalPhotosLibraryClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InternalPhotosLibraryClient create(PhotosLibraryStub stub) {
        return new InternalPhotosLibraryClient(stub);
    }

    protected InternalPhotosLibraryClient(InternalPhotosLibrarySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PhotosLibraryStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InternalPhotosLibraryClient(PhotosLibraryStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InternalPhotosLibrarySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PhotosLibraryStub getStub() {
        return this.stub;
    }

    public final Album createAlbum(Album album) {
        CreateAlbumRequest request = CreateAlbumRequest.newBuilder().setAlbum(album).build();
        return this.createAlbum(request);
    }

    public final Album createAlbum(CreateAlbumRequest request) {
        return (Album)this.createAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAlbumRequest, Album> createAlbumCallable() {
        return this.stub.createAlbumCallable();
    }

    public final BatchCreateMediaItemsResponse batchCreateMediaItems(String albumId, List<NewMediaItem> newMediaItems, AlbumPosition albumPosition) {
        BatchCreateMediaItemsRequest request = BatchCreateMediaItemsRequest.newBuilder().setAlbumId(albumId).addAllNewMediaItems(newMediaItems).setAlbumPosition(albumPosition).build();
        return this.batchCreateMediaItems(request);
    }

    public final BatchCreateMediaItemsResponse batchCreateMediaItems(BatchCreateMediaItemsRequest request) {
        return (BatchCreateMediaItemsResponse)this.batchCreateMediaItemsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateMediaItemsRequest, BatchCreateMediaItemsResponse> batchCreateMediaItemsCallable() {
        return this.stub.batchCreateMediaItemsCallable();
    }

    public final BatchAddMediaItemsToAlbumResponse batchAddMediaItemsToAlbum(String albumId, List<String> mediaItemIds) {
        BatchAddMediaItemsToAlbumRequest request = BatchAddMediaItemsToAlbumRequest.newBuilder().setAlbumId(albumId).addAllMediaItemIds(mediaItemIds).build();
        return this.batchAddMediaItemsToAlbum(request);
    }

    public final BatchAddMediaItemsToAlbumResponse batchAddMediaItemsToAlbum(BatchAddMediaItemsToAlbumRequest request) {
        return (BatchAddMediaItemsToAlbumResponse)this.batchAddMediaItemsToAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<BatchAddMediaItemsToAlbumRequest, BatchAddMediaItemsToAlbumResponse> batchAddMediaItemsToAlbumCallable() {
        return this.stub.batchAddMediaItemsToAlbumCallable();
    }

    public final SearchMediaItemsPagedResponse searchMediaItems(String albumId) {
        SearchMediaItemsRequest request = SearchMediaItemsRequest.newBuilder().setAlbumId(albumId).build();
        return this.searchMediaItems(request);
    }

    public final SearchMediaItemsPagedResponse searchMediaItems(Filters filters) {
        SearchMediaItemsRequest request = SearchMediaItemsRequest.newBuilder().setFilters(filters).build();
        return this.searchMediaItems(request);
    }

    public final SearchMediaItemsPagedResponse searchMediaItems(SearchMediaItemsRequest request) {
        return (SearchMediaItemsPagedResponse)((Object)this.searchMediaItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchMediaItemsRequest, SearchMediaItemsPagedResponse> searchMediaItemsPagedCallable() {
        return this.stub.searchMediaItemsPagedCallable();
    }

    public final UnaryCallable<SearchMediaItemsRequest, SearchMediaItemsResponse> searchMediaItemsCallable() {
        return this.stub.searchMediaItemsCallable();
    }

    public final ListMediaItemsPagedResponse listMediaItems(ListMediaItemsRequest request) {
        return (ListMediaItemsPagedResponse)((Object)this.listMediaItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMediaItemsRequest, ListMediaItemsPagedResponse> listMediaItemsPagedCallable() {
        return this.stub.listMediaItemsPagedCallable();
    }

    public final UnaryCallable<ListMediaItemsRequest, ListMediaItemsResponse> listMediaItemsCallable() {
        return this.stub.listMediaItemsCallable();
    }

    public final MediaItem getMediaItem(String mediaItemId) {
        GetMediaItemRequest request = GetMediaItemRequest.newBuilder().setMediaItemId(mediaItemId).build();
        return this.getMediaItem(request);
    }

    public final MediaItem getMediaItem(GetMediaItemRequest request) {
        return (MediaItem)this.getMediaItemCallable().call((Object)request);
    }

    public final UnaryCallable<GetMediaItemRequest, MediaItem> getMediaItemCallable() {
        return this.stub.getMediaItemCallable();
    }

    public final BatchGetMediaItemsResponse batchGetMediaItems(List<String> mediaItemIds) {
        BatchGetMediaItemsRequest request = BatchGetMediaItemsRequest.newBuilder().addAllMediaItemIds(mediaItemIds).build();
        return this.batchGetMediaItems(request);
    }

    public final BatchGetMediaItemsResponse batchGetMediaItems(BatchGetMediaItemsRequest request) {
        return (BatchGetMediaItemsResponse)this.batchGetMediaItemsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetMediaItemsRequest, BatchGetMediaItemsResponse> batchGetMediaItemsCallable() {
        return this.stub.batchGetMediaItemsCallable();
    }

    public final ListAlbumsPagedResponse listAlbums(boolean excludeNonAppCreatedData) {
        ListAlbumsRequest request = ListAlbumsRequest.newBuilder().setExcludeNonAppCreatedData(excludeNonAppCreatedData).build();
        return this.listAlbums(request);
    }

    public final ListAlbumsPagedResponse listAlbums(ListAlbumsRequest request) {
        return (ListAlbumsPagedResponse)((Object)this.listAlbumsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAlbumsRequest, ListAlbumsPagedResponse> listAlbumsPagedCallable() {
        return this.stub.listAlbumsPagedCallable();
    }

    public final UnaryCallable<ListAlbumsRequest, ListAlbumsResponse> listAlbumsCallable() {
        return this.stub.listAlbumsCallable();
    }

    public final Album getAlbum(String albumId) {
        GetAlbumRequest request = GetAlbumRequest.newBuilder().setAlbumId(albumId).build();
        return this.getAlbum(request);
    }

    public final Album getAlbum(GetAlbumRequest request) {
        return (Album)this.getAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<GetAlbumRequest, Album> getAlbumCallable() {
        return this.stub.getAlbumCallable();
    }

    public final Album getSharedAlbum(String shareToken) {
        GetSharedAlbumRequest request = GetSharedAlbumRequest.newBuilder().setShareToken(shareToken).build();
        return this.getSharedAlbum(request);
    }

    public final Album getSharedAlbum(GetSharedAlbumRequest request) {
        return (Album)this.getSharedAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<GetSharedAlbumRequest, Album> getSharedAlbumCallable() {
        return this.stub.getSharedAlbumCallable();
    }

    public final AddEnrichmentToAlbumResponse addEnrichmentToAlbum(String albumId, NewEnrichmentItem newEnrichmentItem, AlbumPosition albumPosition) {
        AddEnrichmentToAlbumRequest request = AddEnrichmentToAlbumRequest.newBuilder().setAlbumId(albumId).setNewEnrichmentItem(newEnrichmentItem).setAlbumPosition(albumPosition).build();
        return this.addEnrichmentToAlbum(request);
    }

    public final AddEnrichmentToAlbumResponse addEnrichmentToAlbum(AddEnrichmentToAlbumRequest request) {
        return (AddEnrichmentToAlbumResponse)this.addEnrichmentToAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<AddEnrichmentToAlbumRequest, AddEnrichmentToAlbumResponse> addEnrichmentToAlbumCallable() {
        return this.stub.addEnrichmentToAlbumCallable();
    }

    public final JoinSharedAlbumResponse joinSharedAlbum(String shareToken) {
        JoinSharedAlbumRequest request = JoinSharedAlbumRequest.newBuilder().setShareToken(shareToken).build();
        return this.joinSharedAlbum(request);
    }

    public final JoinSharedAlbumResponse joinSharedAlbum(JoinSharedAlbumRequest request) {
        return (JoinSharedAlbumResponse)this.joinSharedAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<JoinSharedAlbumRequest, JoinSharedAlbumResponse> joinSharedAlbumCallable() {
        return this.stub.joinSharedAlbumCallable();
    }

    public final LeaveSharedAlbumResponse leaveSharedAlbum(String shareToken) {
        LeaveSharedAlbumRequest request = LeaveSharedAlbumRequest.newBuilder().setShareToken(shareToken).build();
        return this.leaveSharedAlbum(request);
    }

    public final LeaveSharedAlbumResponse leaveSharedAlbum(LeaveSharedAlbumRequest request) {
        return (LeaveSharedAlbumResponse)this.leaveSharedAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<LeaveSharedAlbumRequest, LeaveSharedAlbumResponse> leaveSharedAlbumCallable() {
        return this.stub.leaveSharedAlbumCallable();
    }

    public final ShareAlbumResponse shareAlbum(String albumId, SharedAlbumOptions sharedAlbumOptions) {
        ShareAlbumRequest request = ShareAlbumRequest.newBuilder().setAlbumId(albumId).setSharedAlbumOptions(sharedAlbumOptions).build();
        return this.shareAlbum(request);
    }

    public final ShareAlbumResponse shareAlbum(ShareAlbumRequest request) {
        return (ShareAlbumResponse)this.shareAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<ShareAlbumRequest, ShareAlbumResponse> shareAlbumCallable() {
        return this.stub.shareAlbumCallable();
    }

    public final ListSharedAlbumsPagedResponse listSharedAlbums(boolean excludeNonAppCreatedData) {
        ListSharedAlbumsRequest request = ListSharedAlbumsRequest.newBuilder().setExcludeNonAppCreatedData(excludeNonAppCreatedData).build();
        return this.listSharedAlbums(request);
    }

    public final ListSharedAlbumsPagedResponse listSharedAlbums(ListSharedAlbumsRequest request) {
        return (ListSharedAlbumsPagedResponse)((Object)this.listSharedAlbumsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSharedAlbumsRequest, ListSharedAlbumsPagedResponse> listSharedAlbumsPagedCallable() {
        return this.stub.listSharedAlbumsPagedCallable();
    }

    public final UnaryCallable<ListSharedAlbumsRequest, ListSharedAlbumsResponse> listSharedAlbumsCallable() {
        return this.stub.listSharedAlbumsCallable();
    }

    public final UnshareAlbumResponse unshareAlbum(String albumId) {
        UnshareAlbumRequest request = UnshareAlbumRequest.newBuilder().setAlbumId(albumId).build();
        return this.unshareAlbum(request);
    }

    public final UnshareAlbumResponse unshareAlbum(UnshareAlbumRequest request) {
        return (UnshareAlbumResponse)this.unshareAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<UnshareAlbumRequest, UnshareAlbumResponse> unshareAlbumCallable() {
        return this.stub.unshareAlbumCallable();
    }

    public final BatchRemoveMediaItemsFromAlbumResponse batchRemoveMediaItemsFromAlbum(String albumId, List<String> mediaItemIds) {
        BatchRemoveMediaItemsFromAlbumRequest request = BatchRemoveMediaItemsFromAlbumRequest.newBuilder().setAlbumId(albumId).addAllMediaItemIds(mediaItemIds).build();
        return this.batchRemoveMediaItemsFromAlbum(request);
    }

    public final BatchRemoveMediaItemsFromAlbumResponse batchRemoveMediaItemsFromAlbum(BatchRemoveMediaItemsFromAlbumRequest request) {
        return (BatchRemoveMediaItemsFromAlbumResponse)this.batchRemoveMediaItemsFromAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<BatchRemoveMediaItemsFromAlbumRequest, BatchRemoveMediaItemsFromAlbumResponse> batchRemoveMediaItemsFromAlbumCallable() {
        return this.stub.batchRemoveMediaItemsFromAlbumCallable();
    }

    public final Album updateAlbum(Album album) {
        UpdateAlbumRequest request = UpdateAlbumRequest.newBuilder().setAlbum(album).build();
        return this.updateAlbum(request);
    }

    public final Album updateAlbum(Album album, FieldMask updateMask) {
        UpdateAlbumRequest request = UpdateAlbumRequest.newBuilder().setAlbum(album).setUpdateMask(updateMask).build();
        return this.updateAlbum(request);
    }

    public final Album updateAlbum(UpdateAlbumRequest request) {
        return (Album)this.updateAlbumCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAlbumRequest, Album> updateAlbumCallable() {
        return this.stub.updateAlbumCallable();
    }

    public final MediaItem updateMediaItem(MediaItem mediaItem, FieldMask updateMask) {
        UpdateMediaItemRequest request = UpdateMediaItemRequest.newBuilder().setMediaItem(mediaItem).setUpdateMask(updateMask).build();
        return this.updateMediaItem(request);
    }

    public final MediaItem updateMediaItem(UpdateMediaItemRequest request) {
        return (MediaItem)this.updateMediaItemCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateMediaItemRequest, MediaItem> updateMediaItemCallable() {
        return this.stub.updateMediaItemCallable();
    }

    public void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSharedAlbumsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album, ListSharedAlbumsPage, ListSharedAlbumsFixedSizeCollection> {
        private ListSharedAlbumsFixedSizeCollection(List<ListSharedAlbumsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSharedAlbumsFixedSizeCollection createEmptyCollection() {
            return new ListSharedAlbumsFixedSizeCollection(null, 0);
        }

        protected ListSharedAlbumsFixedSizeCollection createCollection(List<ListSharedAlbumsPage> pages, int collectionSize) {
            return new ListSharedAlbumsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSharedAlbumsPage
    extends AbstractPage<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album, ListSharedAlbumsPage> {
        private ListSharedAlbumsPage(PageContext<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album> context, ListSharedAlbumsResponse response) {
            super(context, (Object)response);
        }

        private static ListSharedAlbumsPage createEmptyPage() {
            return new ListSharedAlbumsPage(null, null);
        }

        protected ListSharedAlbumsPage createPage(PageContext<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album> context, ListSharedAlbumsResponse response) {
            return new ListSharedAlbumsPage(context, response);
        }

        public ApiFuture<ListSharedAlbumsPage> createPageAsync(PageContext<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album> context, ApiFuture<ListSharedAlbumsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSharedAlbumsPagedResponse
    extends AbstractPagedListResponse<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album, ListSharedAlbumsPage, ListSharedAlbumsFixedSizeCollection> {
        public static ApiFuture<ListSharedAlbumsPagedResponse> createAsync(PageContext<ListSharedAlbumsRequest, ListSharedAlbumsResponse, Album> context, ApiFuture<ListSharedAlbumsResponse> futureResponse) {
            ApiFuture<ListSharedAlbumsPage> futurePage = ListSharedAlbumsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSharedAlbumsPage, ListSharedAlbumsPagedResponse>(){

                public ListSharedAlbumsPagedResponse apply(ListSharedAlbumsPage input) {
                    return new ListSharedAlbumsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSharedAlbumsPagedResponse(ListSharedAlbumsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSharedAlbumsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAlbumsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAlbumsRequest, ListAlbumsResponse, Album, ListAlbumsPage, ListAlbumsFixedSizeCollection> {
        private ListAlbumsFixedSizeCollection(List<ListAlbumsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAlbumsFixedSizeCollection createEmptyCollection() {
            return new ListAlbumsFixedSizeCollection(null, 0);
        }

        protected ListAlbumsFixedSizeCollection createCollection(List<ListAlbumsPage> pages, int collectionSize) {
            return new ListAlbumsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAlbumsPage
    extends AbstractPage<ListAlbumsRequest, ListAlbumsResponse, Album, ListAlbumsPage> {
        private ListAlbumsPage(PageContext<ListAlbumsRequest, ListAlbumsResponse, Album> context, ListAlbumsResponse response) {
            super(context, (Object)response);
        }

        private static ListAlbumsPage createEmptyPage() {
            return new ListAlbumsPage(null, null);
        }

        protected ListAlbumsPage createPage(PageContext<ListAlbumsRequest, ListAlbumsResponse, Album> context, ListAlbumsResponse response) {
            return new ListAlbumsPage(context, response);
        }

        public ApiFuture<ListAlbumsPage> createPageAsync(PageContext<ListAlbumsRequest, ListAlbumsResponse, Album> context, ApiFuture<ListAlbumsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAlbumsPagedResponse
    extends AbstractPagedListResponse<ListAlbumsRequest, ListAlbumsResponse, Album, ListAlbumsPage, ListAlbumsFixedSizeCollection> {
        public static ApiFuture<ListAlbumsPagedResponse> createAsync(PageContext<ListAlbumsRequest, ListAlbumsResponse, Album> context, ApiFuture<ListAlbumsResponse> futureResponse) {
            ApiFuture<ListAlbumsPage> futurePage = ListAlbumsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAlbumsPage, ListAlbumsPagedResponse>(){

                public ListAlbumsPagedResponse apply(ListAlbumsPage input) {
                    return new ListAlbumsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAlbumsPagedResponse(ListAlbumsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAlbumsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMediaItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem, ListMediaItemsPage, ListMediaItemsFixedSizeCollection> {
        private ListMediaItemsFixedSizeCollection(List<ListMediaItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMediaItemsFixedSizeCollection createEmptyCollection() {
            return new ListMediaItemsFixedSizeCollection(null, 0);
        }

        protected ListMediaItemsFixedSizeCollection createCollection(List<ListMediaItemsPage> pages, int collectionSize) {
            return new ListMediaItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMediaItemsPage
    extends AbstractPage<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem, ListMediaItemsPage> {
        private ListMediaItemsPage(PageContext<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem> context, ListMediaItemsResponse response) {
            super(context, (Object)response);
        }

        private static ListMediaItemsPage createEmptyPage() {
            return new ListMediaItemsPage(null, null);
        }

        protected ListMediaItemsPage createPage(PageContext<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem> context, ListMediaItemsResponse response) {
            return new ListMediaItemsPage(context, response);
        }

        public ApiFuture<ListMediaItemsPage> createPageAsync(PageContext<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem> context, ApiFuture<ListMediaItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMediaItemsPagedResponse
    extends AbstractPagedListResponse<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem, ListMediaItemsPage, ListMediaItemsFixedSizeCollection> {
        public static ApiFuture<ListMediaItemsPagedResponse> createAsync(PageContext<ListMediaItemsRequest, ListMediaItemsResponse, MediaItem> context, ApiFuture<ListMediaItemsResponse> futureResponse) {
            ApiFuture<ListMediaItemsPage> futurePage = ListMediaItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListMediaItemsPage, ListMediaItemsPagedResponse>(){

                public ListMediaItemsPagedResponse apply(ListMediaItemsPage input) {
                    return new ListMediaItemsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListMediaItemsPagedResponse(ListMediaItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMediaItemsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchMediaItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem, SearchMediaItemsPage, SearchMediaItemsFixedSizeCollection> {
        private SearchMediaItemsFixedSizeCollection(List<SearchMediaItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchMediaItemsFixedSizeCollection createEmptyCollection() {
            return new SearchMediaItemsFixedSizeCollection(null, 0);
        }

        protected SearchMediaItemsFixedSizeCollection createCollection(List<SearchMediaItemsPage> pages, int collectionSize) {
            return new SearchMediaItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchMediaItemsPage
    extends AbstractPage<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem, SearchMediaItemsPage> {
        private SearchMediaItemsPage(PageContext<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem> context, SearchMediaItemsResponse response) {
            super(context, (Object)response);
        }

        private static SearchMediaItemsPage createEmptyPage() {
            return new SearchMediaItemsPage(null, null);
        }

        protected SearchMediaItemsPage createPage(PageContext<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem> context, SearchMediaItemsResponse response) {
            return new SearchMediaItemsPage(context, response);
        }

        public ApiFuture<SearchMediaItemsPage> createPageAsync(PageContext<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem> context, ApiFuture<SearchMediaItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchMediaItemsPagedResponse
    extends AbstractPagedListResponse<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem, SearchMediaItemsPage, SearchMediaItemsFixedSizeCollection> {
        public static ApiFuture<SearchMediaItemsPagedResponse> createAsync(PageContext<SearchMediaItemsRequest, SearchMediaItemsResponse, MediaItem> context, ApiFuture<SearchMediaItemsResponse> futureResponse) {
            ApiFuture<SearchMediaItemsPage> futurePage = SearchMediaItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchMediaItemsPage, SearchMediaItemsPagedResponse>(){

                public SearchMediaItemsPagedResponse apply(SearchMediaItemsPage input) {
                    return new SearchMediaItemsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchMediaItemsPagedResponse(SearchMediaItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchMediaItemsFixedSizeCollection.createEmptyCollection());
        }
    }
}

