/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1;

import com.google.api.core.ApiClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.photos.library.v1.internal.InternalPhotosLibrarySettings;
import com.google.photos.library.v1.internal.stub.PhotosLibraryStubSettings;
import com.google.photos.library.v1.upload.UploadMediaItemRequest;
import com.google.photos.library.v1.upload.UploadMediaItemResponse;
import java.io.IOException;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public final class PhotosLibrarySettings
extends InternalPhotosLibrarySettings {
    private static final String DEFAULT_UPLOAD_ENDPOINT = "https://photoslibrary.googleapis.com/v1/uploads";
    private final UnaryCallSettings<UploadMediaItemRequest, UploadMediaItemResponse> uploadMediaItemSettings;

    protected PhotosLibrarySettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.uploadMediaItemSettings = settingsBuilder.uploadMediaItemSettingsBuilder().build();
    }

    public UnaryCallSettings<UploadMediaItemRequest, UploadMediaItemResponse> uploadMediaItemSettings() {
        return this.uploadMediaItemSettings;
    }

    public static String getUploadEndpoint() {
        return DEFAULT_UPLOAD_ENDPOINT;
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static final class Builder
    extends InternalPhotosLibrarySettings.Builder {
        private UnaryCallSettings.Builder<UploadMediaItemRequest, UploadMediaItemResponse> uploadMediaItemSettingsBuilder = UnaryCallSettings.newUnaryCallSettingsBuilder();

        private Builder() throws IOException {
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
        }

        private Builder(InternalPhotosLibrarySettings settings) {
            super(settings);
        }

        private Builder(PhotosLibraryStubSettings.Builder stubSettings) {
            super(stubSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            super.setHeaderProvider(headerProvider);
            return this;
        }

        protected Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            super.setInternalHeaderProvider(internalHeaderProvider);
            return this;
        }

        public Builder setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
            super.setTransportChannelProvider(transportChannelProvider);
            return this;
        }

        public Builder setClock(ApiClock clock) {
            super.setClock(clock);
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            super.setEndpoint(endpoint);
            return this;
        }

        public Builder setWatchdogProvider(@Nullable WatchdogProvider watchdogProvider) {
            super.setWatchdogProvider(watchdogProvider);
            return this;
        }

        public Builder setWatchdogCheckInterval(@Nullable Duration checkInterval) {
            super.setWatchdogCheckInterval(checkInterval);
            return this;
        }

        @Override
        public PhotosLibrarySettings build() throws IOException {
            return new PhotosLibrarySettings(this);
        }

        public UnaryCallSettings.Builder<UploadMediaItemRequest, UploadMediaItemResponse> uploadMediaItemSettingsBuilder() {
            return this.uploadMediaItemSettingsBuilder;
        }

        public static Builder createDefault() {
            return new Builder(PhotosLibraryStubSettings.newBuilder());
        }
    }
}

