/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.v1;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Strings;
import com.google.photos.library.v1.PhotosLibrarySettings;
import com.google.photos.library.v1.internal.InternalPhotosLibraryClient;
import com.google.photos.library.v1.internal.stub.PhotosLibraryStub;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsRequest;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsResponse;
import com.google.photos.library.v1.proto.ListMediaItemsRequest;
import com.google.photos.library.v1.proto.NewMediaItem;
import com.google.photos.library.v1.upload.PhotosLibraryUploadStub;
import com.google.photos.library.v1.upload.PhotosLibraryUploadStubImpl;
import com.google.photos.library.v1.upload.UploadMediaItemRequest;
import com.google.photos.library.v1.upload.UploadMediaItemResponse;
import com.google.photos.types.proto.Album;
import com.google.photos.types.proto.MediaItem;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;

public final class PhotosLibraryClient
extends InternalPhotosLibraryClient {
    private final PhotosLibraryUploadStub uploadStub;
    private final PhotosLibrarySettings settings;

    protected PhotosLibraryClient(PhotosLibrarySettings settings) throws IOException {
        super(settings);
        this.settings = settings;
        this.uploadStub = PhotosLibraryUploadStubImpl.createStub(settings);
    }

    protected PhotosLibraryClient(PhotosLibraryStub stub, PhotosLibraryUploadStub uploadStub) {
        super(stub);
        this.settings = null;
        this.uploadStub = uploadStub;
    }

    public static PhotosLibraryClient initialize(PhotosLibrarySettings settings) throws IOException {
        return new PhotosLibraryClient(settings);
    }

    public final UnaryCallable<UploadMediaItemRequest, UploadMediaItemResponse> uploadMediaItemCallable() {
        return this.uploadStub.uploadMediaItemCallable();
    }

    public final UploadMediaItemResponse uploadMediaItem(UploadMediaItemRequest request) {
        return (UploadMediaItemResponse)this.uploadStub.uploadMediaItemCallable().call((Object)request);
    }

    public final BatchCreateMediaItemsResponse batchCreateMediaItems(List<NewMediaItem> newMediaItems) {
        if (newMediaItems == null) {
            throw new InvalidArgumentException("Request must have a list of new media items.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
        }
        BatchCreateMediaItemsRequest request = BatchCreateMediaItemsRequest.newBuilder().addAllNewMediaItems(newMediaItems).build();
        return this.batchCreateMediaItems(request);
    }

    public final BatchCreateMediaItemsResponse batchCreateMediaItems(String albumId, List<NewMediaItem> newMediaItems) {
        if (Strings.isNullOrEmpty((String)albumId)) {
            throw new InvalidArgumentException("Request must have an album id.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
        }
        BatchCreateMediaItemsRequest request = BatchCreateMediaItemsRequest.newBuilder().setAlbumId(albumId).addAllNewMediaItems(newMediaItems).build();
        return this.batchCreateMediaItems(request);
    }

    public final Album createAlbum(String albumTitle) {
        if (Strings.isNullOrEmpty((String)albumTitle)) {
            throw new IllegalArgumentException("The album title cannot be null or empty.");
        }
        return super.createAlbum(Album.newBuilder().setTitle(albumTitle).build());
    }

    public final Album updateAlbumTitle(Album album, String newTitle) {
        if (Strings.isNullOrEmpty((String)newTitle)) {
            throw new IllegalArgumentException("The new album title cannot be null or empty.");
        }
        Album newAlbum = Album.newBuilder(album).setTitle(newTitle).build();
        FieldMask updateMask = FieldMask.newBuilder().addPaths("title").build();
        return super.updateAlbum(newAlbum, updateMask);
    }

    public final Album updateAlbumCoverPhoto(Album album, MediaItem newCoverPhotoMediaItem) {
        if (newCoverPhotoMediaItem == null) {
            throw new IllegalArgumentException("The new cover photo media item cannot be null.");
        }
        return this.updateAlbumCoverPhoto(album, newCoverPhotoMediaItem.getId());
    }

    public final Album updateAlbumCoverPhoto(Album album, String newCoverPhotoMediaItemId) {
        if (Strings.isNullOrEmpty((String)newCoverPhotoMediaItemId)) {
            throw new IllegalArgumentException("The new cover photo media item identifier cannot be null.");
        }
        Album newAlbum = Album.newBuilder(album).setCoverPhotoMediaItemId(newCoverPhotoMediaItemId).build();
        FieldMask updateMask = FieldMask.newBuilder().addPaths("cover_photo_media_item_id").build();
        return super.updateAlbum(newAlbum, updateMask);
    }

    public final MediaItem updateMediaItemDescription(MediaItem mediaItem, String newDescription) {
        if (newDescription == null) {
            throw new IllegalArgumentException("The new edia item description cannot be null.");
        }
        MediaItem newMediaItem = MediaItem.newBuilder(mediaItem).setDescription(newDescription).build();
        FieldMask updateMask = FieldMask.newBuilder().addPaths("description").build();
        return super.updateMediaItem(newMediaItem, updateMask);
    }

    public final InternalPhotosLibraryClient.ListAlbumsPagedResponse listAlbums() {
        return super.listAlbums(false);
    }

    public final InternalPhotosLibraryClient.ListMediaItemsPagedResponse listMediaItems() {
        return super.listMediaItems(ListMediaItemsRequest.newBuilder().build());
    }

    public final InternalPhotosLibraryClient.ListSharedAlbumsPagedResponse listSharedAlbums() {
        return super.listSharedAlbums(false);
    }

    @Override
    public void close() {
        super.close();
        try {
            this.uploadStub.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

