/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rychly.gphotos_uploader.logger;

import io.gitlab.rychly.gphotos_uploader.logger.AnsiConsoleHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoggerFactory {
    public static final Level DEFAULT_CONSOLE_LOG_LEVEL = Level.CONFIG;
    public static final Level DEFAULT_FILE_LOG_LEVEL = Level.ALL;
    public static final String TEMP_LOG_FILE_PATTERN = "%t/{}.log";
    public static final Logger TOP_LOGGER = Logger.getLogger("");
    public static final String HANDLER_ENCODING = "UTF-8";
    public static final DateFormat TEMP_LOG_FILE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private static Logger logger = TOP_LOGGER;

    public static boolean init(String loggerName) {
        if (logger == TOP_LOGGER) {
            LoggerFactory.appendLogger(loggerName);
            return true;
        }
        return false;
    }

    public static Logger appendLogger(String loggerName) {
        Logger newLogger;
        loggerName = loggerName.replace('.', '-');
        if (logger.getName().isEmpty()) {
            newLogger = Logger.getLogger(loggerName);
            newLogger.setUseParentHandlers(false);
        } else {
            newLogger = Logger.getLogger(logger.getName() + "." + loggerName);
        }
        newLogger.setLevel(Level.ALL);
        logger = newLogger;
        return newLogger;
    }

    @Contract(pure=true)
    public static Logger getLogger() {
        return logger;
    }

    @Contract(value="_, _ -> param1")
    public static Handler addHandler(Handler handler, Level level) {
        if (level != null) {
            handler.setLevel(level);
        }
        try {
            handler.setEncoding(HANDLER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, "Cannot set UTF-8 encoding on the handler.", e);
        }
        logger.addHandler(handler);
        return handler;
    }

    public static Handler addAnsiConsoleHandler() {
        return LoggerFactory.addAnsiConsoleHandler(DEFAULT_CONSOLE_LOG_LEVEL);
    }

    public static Handler addAnsiConsoleHandler(Level level) {
        AnsiConsoleHandler handler = new AnsiConsoleHandler();
        handler.setFormatter(new ConsoleFormatter());
        return LoggerFactory.addHandler(handler, level);
    }

    public static Handler addFileHandler(String fileNamePattern) {
        return LoggerFactory.addFileHandler(fileNamePattern, DEFAULT_FILE_LOG_LEVEL);
    }

    @Nullable
    public static Handler addFileHandler(String fileNamePattern, Level level) {
        try {
            FileHandler handler = new FileHandler(fileNamePattern);
            return LoggerFactory.addHandler(handler, level);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Cannot create and add the file handler to the bottom logger.", e);
            return null;
        }
    }

    @Contract(pure=true)
    public static Level loggingLevelForVerbosity(int verbosity) {
        switch (verbosity) {
            case -3: {
                return Level.SEVERE;
            }
            case -2: {
                return Level.WARNING;
            }
            case -1: {
                return Level.INFO;
            }
            case 0: {
                return Level.CONFIG;
            }
            case 1: {
                return Level.FINE;
            }
            case 2: {
                return Level.FINER;
            }
            case 3: {
                return Level.FINEST;
            }
        }
        return verbosity < -3 ? Level.OFF : Level.ALL;
    }

    @NotNull
    @Contract(pure=true)
    public static String tempLogFilePatternForName(String baseName) {
        return TEMP_LOG_FILE_PATTERN.replace("{}", baseName + "." + TEMP_LOG_FILE_DATE_FORMAT.format(new Date()));
    }

    public static String dumpObjectToString(Object object) {
        return new ReflectionToStringBuilder(object, (ToStringStyle)new RecursiveToStringStyle()).toString();
    }

    public static void demoLog(@NotNull Logger logger) {
        logger.log(Level.SEVERE, "Severe message.");
        logger.log(Level.WARNING, "Warning message.");
        logger.log(Level.INFO, "Info message.");
        logger.log(Level.CONFIG, "Config message.");
        logger.log(Level.FINE, "Fine message.");
        logger.log(Level.FINER, "Finer message.");
        logger.log(Level.FINEST, "Finest message.");
    }

    public static void main(String[] args) throws IOException {
        LoggerFactory.init(LoggerFactory.class.getCanonicalName());
        LoggerFactory.addAnsiConsoleHandler(LoggerFactory.loggingLevelForVerbosity(0));
        LoggerFactory.addFileHandler(LoggerFactory.tempLogFilePatternForName(LoggerFactory.class.getCanonicalName()));
        LoggerFactory.demoLog(LoggerFactory.getLogger());
    }

    public static class ConsoleFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            return String.valueOf(record.getLevel()) + ":\t" + this.formatMessage(record) + "\n";
        }
    }
}

