/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rychly.gphotos_uploader.gphotos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MediaFile
extends File {
    public static final String PHOTO_FILENAME_REGEXP_EXTENSIONS = "jpg|png|webp|crw|cr2|nef|orf|raf|arw|pef|srw|rw2|dng";
    public static final String PHOTO_FILENAME_REGEXP = "(?i).*\\.(jpg|png|webp|crw|cr2|nef|orf|raf|arw|pef|srw|rw2|dng)";
    public static final String VIDEO_FILENAME_REGEXP_EXTENSIONS = "mpg|mod|mmv|tod|wmv|asf|avi|divx|mov|m4v|3gp|3g2|mp4|m2t|m2ts|mts|mkv";
    public static final String VIDEO_FILENAME_REGEXP = "(?i).*\\.(mpg|mod|mmv|tod|wmv|asf|avi|divx|mov|m4v|3gp|3g2|mp4|m2t|m2ts|mts|mkv)";
    public static final String MEDIA_FILENAME_REGEXP = "(?i).*\\.(jpg|png|webp|crw|cr2|nef|orf|raf|arw|pef|srw|rw2|dng|mpg|mod|mmv|tod|wmv|asf|avi|divx|mov|m4v|3gp|3g2|mp4|m2t|m2ts|mts|mkv)";
    public static final String CHECKSUM_ALGORITHM = "SHA-1";
    public static final String DESCRIPTION_ITEMS_SEPARATOR = ";";
    private byte[] checksum;

    public MediaFile(@NotNull String pathname) {
        super(pathname);
    }

    public MediaFile(String parent, @NotNull String child) {
        super(parent, child);
    }

    public MediaFile(File parent, @NotNull String child) {
        super(parent, child);
    }

    public MediaFile(@NotNull URI uri) {
        super(uri);
    }

    public MediaFile(@NotNull File file) {
        this(file.getAbsolutePath());
    }

    public static Stream<MediaFile> fileFinder(File directory) throws FileNotFoundException {
        return MediaFile.fileFinder(directory, MEDIA_FILENAME_REGEXP);
    }

    public static Stream<MediaFile> fileFinder(File directory, String fileNameRegExp) throws FileNotFoundException {
        File[] files = directory.listFiles((File pathname) -> pathname.isFile() && !pathname.isHidden() && pathname.getName().matches(fileNameRegExp));
        if (files == null) {
            throw new FileNotFoundException("Cannot find media files in directory " + String.valueOf(directory));
        }
        Arrays.sort(files, Comparator.comparing(File::getName));
        return Arrays.stream(files).map(MediaFile::new);
    }

    @Nullable
    private static String extractDescriptionItem(@NotNull String description, int itemNumber) {
        String[] splitDescription = description.trim().split("\\s*;\\s*");
        return itemNumber < splitDescription.length ? splitDescription[itemNumber] : null;
    }

    @Nullable
    public static String extractChecksumStringFromDescription(@NotNull String description) {
        return MediaFile.extractDescriptionItem(description, 0);
    }

    @Nullable
    public static ZonedDateTime extractLastModifiedDateFromDescription(@NotNull String description) {
        String formattedZonedDateTime = MediaFile.extractDescriptionItem(description, 1);
        return formattedZonedDateTime == null ? null : ZonedDateTime.parse(formattedZonedDateTime);
    }

    public boolean isPhoto() {
        return this.getName().matches(PHOTO_FILENAME_REGEXP);
    }

    public boolean isVideo() {
        return this.getName().matches(VIDEO_FILENAME_REGEXP);
    }

    public void setContentChecksum() throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(CHECKSUM_ALGORITHM);
        try (FileInputStream fileInputStream = new FileInputStream(this);){
            byte[] buffer = new byte[8192];
            int n = 0;
            while (n != -1) {
                n = ((InputStream)fileInputStream).read(buffer);
                if (n <= 0) continue;
                messageDigest.update(buffer, 0, n);
            }
            this.checksum = messageDigest.digest();
        }
    }

    public byte[] getContentChecksum() throws NoSuchAlgorithmException, IOException {
        if (this.checksum == null) {
            this.setContentChecksum();
        }
        return this.checksum;
    }

    public String getContentChecksumString() throws NoSuchAlgorithmException, IOException {
        int checksumSizeInHalfBytes = this.getContentChecksum().length * 2;
        return String.format("SHA-1:%0" + checksumSizeInHalfBytes + "x", new BigInteger(1, this.getContentChecksum()));
    }

    public boolean isChecksumStringMatching(String checksumString) throws IOException, NoSuchAlgorithmException {
        return this.getContentChecksumString().equalsIgnoreCase(checksumString);
    }

    public ZonedDateTime getLastModifiedDate() throws IOException {
        return Files.getLastModifiedTime(this.toPath(), new LinkOption[0]).toInstant().atZone(ZoneId.systemDefault());
    }

    public String generateDescription() throws IOException, NoSuchAlgorithmException {
        return this.getContentChecksumString() + "; " + this.getLastModifiedDate().format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }
}

