/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rychly.gphotos_uploader.config;

import io.gitlab.rychly.gphotos_uploader.i18n.ResourceBundleFactory;
import io.gitlab.rychly.gphotos_uploader.logger.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class Config {
    private static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    private static final String XDG_CONFIG_DIRS = "XDG_CONFIG_DIRS";
    private static Map<String, String> environment = System.getenv();
    private String applicationDirectoryName;

    public Config(String applicationDirectoryName) {
        this.applicationDirectoryName = applicationDirectoryName;
    }

    private static String getEnvironmentVariableValueOrDefault(String variableName, String defaultValue) {
        String variableValue = environment.get(variableName);
        return variableValue == null || variableValue.trim().length() == 0 ? defaultValue : variableValue;
    }

    public static Properties loadPropertiesFromInputStreamOrGetEmpty(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("CannotLoadProperties(%s)", e.getMessage()), e);
        }
        return properties;
    }

    public static Properties loadPropertiesFromClassPathOrEmpty(String fileName) {
        Properties properties;
        block8: {
            InputStream inputStream = Config.class.getClassLoader().getResourceAsStream(fileName);
            try {
                properties = Config.loadPropertiesFromInputStreamOrGetEmpty(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("CannotLoadProperties(%s)", e.getMessage()), e);
                    return new Properties();
                }
            }
            inputStream.close();
        }
        return properties;
    }

    @NotNull
    private String[] getConfigDirs() {
        return this.getConfigDirs(".");
    }

    @NotNull
    private String[] getConfigDirs(String firstConfigDir) {
        String defaultCfgHome = environment.get("HOME") + File.separator + ".config";
        String defaultCfgSystem = File.separator + "etc" + File.separator + "xdg";
        String allConfigDirs = firstConfigDir + File.pathSeparator + Config.getEnvironmentVariableValueOrDefault(XDG_CONFIG_HOME, defaultCfgHome) + File.separator + this.applicationDirectoryName + File.pathSeparator + Config.getEnvironmentVariableValueOrDefault(XDG_CONFIG_DIRS, defaultCfgSystem) + File.separator + this.applicationDirectoryName;
        return allConfigDirs.split(File.pathSeparator);
    }

    public File getConfigFile(String fileName) throws IOException {
        return this.getConfigFile(fileName, false);
    }

    public File getConfigFile(String fileName, boolean createInWorkingAndNotInHomeConfigDir) throws IOException {
        String[] configDirs;
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        for (String path : configDirs = this.getConfigDirs()) {
            File configFile = new File(path, fileName);
            if (!configFile.canRead()) continue;
            return configFile;
        }
        int defaultCfgDirIndex = createInWorkingAndNotInHomeConfigDir ? 0 : 1;
        File configFile = new File(configDirs[defaultCfgDirIndex], fileName);
        File configFileParentDirectory = configFile.getParentFile();
        if (!configFileParentDirectory.exists()) {
            Files.createDirectory(configFileParentDirectory.toPath(), new FileAttribute[0]);
        }
        if (fileName.endsWith(File.separator)) {
            Files.createDirectory(configFile.toPath(), new FileAttribute[0]);
        } else {
            configFile.createNewFile();
        }
        return configFile;
    }

    public Properties loadPropertiesFromConfigFileOrEmpty(String fileName) {
        return this.loadPropertiesFromConfigFileOrEmpty(fileName, false);
    }

    public Properties loadPropertiesFromConfigFileOrEmpty(String fileName, boolean createInWorkingAndNotInHomeConfigDir) {
        Properties properties;
        FileInputStream inputStream = new FileInputStream(this.getConfigFile(fileName, createInWorkingAndNotInHomeConfigDir));
        try {
            properties = Config.loadPropertiesFromInputStreamOrGetEmpty(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("CannotLoadProperties(%s)", e.getMessage()), e);
                return new Properties();
            }
        }
        ((InputStream)inputStream).close();
        return properties;
    }

    public void storePropertiesIntoConfigFile(String fileName, @NotNull Properties properties) throws IOException {
        this.storePropertiesIntoConfigFile(fileName, properties, false, false);
    }

    public void storePropertiesIntoConfigFile(String fileName, @NotNull Properties properties, boolean appendNotOverwrite, boolean createInWorkingAndNotInHomeConfigDir) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(this.getConfigFile(fileName, createInWorkingAndNotInHomeConfigDir), appendNotOverwrite);){
            properties.store(outputStream, null);
        }
    }
}

