/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rychly.gphotos_uploader;

import com.google.api.gax.rpc.ApiException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.photos.library.sample.factories.PhotosLibraryClientFactory;
import com.google.photos.library.v1.PhotosLibraryClient;
import com.google.photos.library.v1.proto.ShareAlbumResponse;
import com.google.photos.types.proto.Album;
import com.google.photos.types.proto.MediaItem;
import com.google.photos.types.proto.SharedAlbumOptions;
import io.gitlab.rychly.gphotos_uploader.config.Config;
import io.gitlab.rychly.gphotos_uploader.gphotos.GPhotos;
import io.gitlab.rychly.gphotos_uploader.gphotos.MediaFile;
import io.gitlab.rychly.gphotos_uploader.i18n.ResourceBundleFactory;
import io.gitlab.rychly.gphotos_uploader.logger.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="GPhotosUploader", versionProvider=GradlePropertiesVersionProvider.class, description={"Uploads missing media files into Google Photos and control their sharing."}, mixinStandardHelpOptions=true, showDefaultValues=true, sortOptions=false)
public class GPhotosUploader
implements Runnable {
    private static final String CONFIG_KEY_CREDENTIALS_FILE = "google.api.credentials.client-secret.file";
    private static final String CONFIG_KEY_CREDENTIALS_DIRECTORY = "google.api.credentials.directory";
    private static final String CONFIG_KEY_LOGGER_CONSOLE_LEVEL_NAME = "logger.console.levelName";
    private static final String CONFIG_FILE = GPhotosUploader.class.getSimpleName() + ".properties";
    private static final String CREDENTIALS_FILE = "client_secret.json";
    private static final String CREDENTIALS_DIRECTORY = "credentials";
    private static final List<String> REQUIRED_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/photoslibrary.readonly", (Object)"https://www.googleapis.com/auth/photoslibrary.appendonly", (Object)"https://www.googleapis.com/auth/photoslibrary.sharing");
    private Config config;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Verbose mode; -v, -vv, or -vvv for FINE, FINER, or FINEST logging level."})
    private boolean[] verbose = new boolean[0];
    @CommandLine.Option(names={"-q", "--quiet", "--silent"}, description={"Quiet/silent mode; -q, -qq, or -qqq for INFO, WARNING, SEVERE logging level."})
    private boolean[] quiet = new boolean[0];
    @CommandLine.Option(names={"-c", "--config"}, description={"Name of or path to the configuration file."})
    private String configFile = CONFIG_FILE;
    @CommandLine.Option(names={"-g", "--credentials-profile"}, arity="0..*", description={"Profile name for Google API credentials configuration (the default value is empty). In the case of multiple profile names (multiple parameter values), the actions specified by other parameters will be executed for all of them."})
    private String[] credentialsProfiles;
    @CommandLine.Option(names={"-l", "--list-albums"}, arity="0..1", description={"List online albums matching particular regular expression in the alphabetical order (the empty expression matches all)."})
    private String listAlbums;
    @CommandLine.Option(names={"-p", "---list-shared-albums"}, arity="0..1", description={"List shared/public online albums matching particular regular expression in the alphabetical order (the empty expression matches all)."})
    private String listSharedAlbums;
    @CommandLine.Option(names={"-u", "--unshare-albums"}, arity="0..1", description={"Unshare shared online albums matching particular regular expression in the alphabetical order (the empty expression matches all)."})
    private String unshareAlbums;
    @CommandLine.Option(names={"-s", "--share-albums"}, arity="0..1", description={"Share (by URL) online albums matching particular regular expression in the alphabetical order (the empty expression matches all)."})
    private String shareAlbums;
    @CommandLine.Option(names={"-o", "--collaborative-sharing"}, description={"When sharing albums, enable the collaborative sharing (i.e., other user can contribute their media files into the album)."})
    private boolean collaborativeSharing = false;
    @CommandLine.Option(names={"-m", "--commentable-sharing"}, description={"When sharing albums, enable the commentable sharing (i.e., other user can create comments on media files in the album)."})
    private boolean commentableSharing = false;
    @CommandLine.Option(names={"-f", "--import-export-file"}, arity="0..1", description={"File to import from or export into for the share tokens import/export."})
    private File importExportFile = new File("gphotos-share-tokens.txt");
    @CommandLine.Option(names={"-e", "--export-share-tokens"}, arity="0..1", description={"Export share tokens of shared online albums matching particular regular expression into the alphabetical order in a file (the empty expression matches all; also see the import-export file option)."})
    private String exportSharedAlbums;
    @CommandLine.Option(names={"-i", "--import-share-tokens"}, arity="0..2", description={"Import share tokens from a file and join their shared online albums (see the import-export file option). All the tokens will be imported (no parameter values), or the first N tokens will be imported (one parameter value), or tokens from the N-th to M-th token will be imported (two parameter values). The first token has number 1 (not zero)."})
    private int[] importShareTokens;
    @CommandLine.Option(names={"-d", "--leave-share-tokens"}, description={"Use share tokens from a file to leave their shared online albums (see the import-export file option)."})
    private boolean leaveShareTokens;
    @CommandLine.Parameters(arity="0..*", paramLabel="media-directory", description={"Directory(ies) of media files to process (recursively; the album name will be a plain directory name, without its parent path)."})
    private File[] inputDirectories;

    private GPhotosUploader(Config config) {
        this.config = config;
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new GPhotosUploader(new Config(GPhotosUploader.class.getSimpleName())));
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    private void exportShareTokens(PhotosLibraryClient photosLibraryClient, File exportedFile, String regexPattern) {
        Stream<String> exportLinesStream = GPhotos.getSharedAlbumsStreamByTitle(photosLibraryClient, regexPattern, true).sorted(Comparator.comparing(Album::getTitle)).map(album -> {
            LoggerFactory.getLogger().info(ResourceBundleFactory.msg("ExportingToken(%s,%s)", album.getTitle(), album.getShareInfo().getShareableUrl()));
            return album.getShareInfo().getShareToken() + " # " + album.getTitle() + "; " + album.getShareInfo().getShareableUrl();
        });
        try {
            Files.write(exportedFile.toPath(), exportLinesStream::iterator, StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("ExportError(%s,%s)", exportedFile.getAbsolutePath(), e.getMessage()), e);
        }
    }

    private void importShareTokens(PhotosLibraryClient photosLibraryClient, File importedFile, int tokensFromNo, int tokensToNo) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        try {
            Files.lines(importedFile.toPath()).flatMap(line -> {
                String token = line.split("#", 2)[0].trim();
                return token.isEmpty() ? Stream.empty() : Stream.of(token);
            }).map(token -> Pair.of((Object)atomicInteger.getAndIncrement(), (Object)token)).limit(tokensToNo + 1).skip(tokensFromNo).flatMap(indexTokenPair -> {
                try {
                    return Stream.of(Pair.of((Object)((Integer)indexTokenPair.getLeft()), (Object)photosLibraryClient.joinSharedAlbum((String)indexTokenPair.getRight()).getAlbum()));
                }
                catch (ApiException | NullPointerException e) {
                    LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("SkippingImport(%s,%d,%s,%s)", importedFile.getAbsolutePath(), indexTokenPair.getLeft(), indexTokenPair.getRight(), e.getMessage()), e);
                    return Stream.empty();
                }
            }).forEach(indexAlbumPair -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg("ImportedToken(%d,%s,%s)", indexAlbumPair.getLeft(), ((Album)indexAlbumPair.getRight()).getTitle(), ((Album)indexAlbumPair.getRight()).getProductUrl())));
        }
        catch (IOException e) {
            LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("ImportError(%s,%s)", importedFile.getAbsolutePath(), e.getMessage()), e);
        }
    }

    private void leaveShareTokens(PhotosLibraryClient photosLibraryClient, File importedFile) {
        try {
            Files.lines(importedFile.toPath()).flatMap(line -> {
                String token = line.split("#", 2)[0].trim();
                return token.isEmpty() ? Stream.empty() : Stream.of(token);
            }).flatMap(token -> {
                try {
                    return Stream.of(Pair.of((Object)token, (Object)photosLibraryClient.leaveSharedAlbum(token)));
                }
                catch (ApiException | NullPointerException e) {
                    LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("SkippingLeave(%s,%s,%s)", importedFile.getAbsolutePath(), token, e.getMessage()), e);
                    return Stream.empty();
                }
            }).forEach(pair -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg("LeftToken(%s)", pair.getLeft())));
        }
        catch (IOException e) {
            LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("LeaveError(%s,%s)", importedFile.getAbsolutePath(), e.getMessage()), e);
        }
    }

    private void listAlbums(PhotosLibraryClient photosLibraryClient, String regexPattern) {
        GPhotos.getAlbumsStreamByTitle(photosLibraryClient, regexPattern, true).sorted(Comparator.comparing(Album::getTitle)).forEach(album -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg(album.hasShareInfo() ? "ListSharedAlbum(%s,%s)" : "ListAlbum(%s,%s)", album.getTitle(), album.getProductUrl())));
    }

    private void listSharedAlbums(PhotosLibraryClient photosLibraryClient, String regexPattern) {
        GPhotos.getSharedAlbumsStreamByTitle(photosLibraryClient, regexPattern, true).sorted(Comparator.comparing(Album::getTitle)).forEach(album -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg("ListAlbum(%s,%s)", album.getTitle(), album.hasShareInfo() ? album.getShareInfo().getShareableUrl() : album.getProductUrl())));
    }

    private void processMediaDirectories(PhotosLibraryClient photosLibraryClient, @NotNull File[] directories) {
        for (File directory : directories) {
            LoggerFactory.getLogger().info(ResourceBundleFactory.msg("ProcessingDirectory(%s)", directory.getAbsolutePath()));
            try {
                this.processMediaDirectory(photosLibraryClient, directory, directory.getName());
            }
            catch (IOException | NoSuchAlgorithmException e) {
                LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("ProcessingDirectoryError(%s,%s)", directory.getAbsolutePath(), e.getMessage()), e);
            }
            File[] subDirectories = directory.listFiles(pathname -> pathname.isDirectory() && !pathname.isHidden());
            if (subDirectories == null) continue;
            this.processMediaDirectories(photosLibraryClient, subDirectories);
        }
    }

    private void processMediaDirectory(PhotosLibraryClient photosLibraryClient, File directory, String albumTitle) throws IOException, NoSuchAlgorithmException {
        String mediaItemDescription;
        MediaFile mediaFile;
        LoggerFactory.getLogger().info(ResourceBundleFactory.msg("OpeningAlbum(%s)", albumTitle));
        Album album = GPhotos.getOrCreateAlbum(photosLibraryClient, albumTitle);
        LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("AlbumUrl(%s)", album.getProductUrl()));
        Triple<Collection<MediaItem>, Collection<MediaItem>, Collection<MediaFile>> triple = GPhotos.classifyMediaItemsByFilesAndGetMissingFiles(photosLibraryClient, album, MediaFile.fileFinder(directory));
        Collection matchingMediaItems = (Collection)triple.getLeft();
        Collection nonMatchingMediaItems = (Collection)triple.getMiddle();
        Collection mediaFilesOfMissingMediaItems = (Collection)triple.getRight();
        LoggerFactory.getLogger().info(ResourceBundleFactory.msg("MatchingMediaItems(%d)", matchingMediaItems.size()));
        for (MediaItem mediaItem2 : matchingMediaItems) {
            mediaFile = new MediaFile(directory, mediaItem2.getFilename());
            mediaItemDescription = mediaItem2.getDescription();
            LoggerFactory.getLogger().finer(ResourceBundleFactory.msg("MediaItemFile(%s,%s,%s,%s)", mediaFile.getAbsolutePath(), mediaFile.generateDescription(), mediaItem2.getProductUrl(), mediaItemDescription));
            if (mediaFile.isChecksumStringMatching(MediaFile.extractChecksumStringFromDescription(mediaItemDescription))) continue;
            LoggerFactory.getLogger().warning(ResourceBundleFactory.msg("MatchingMediaItemAction(%s,%s)", mediaFile.getAbsolutePath(), mediaItem2.getProductUrl()));
        }
        LoggerFactory.getLogger().info(ResourceBundleFactory.msg("NonMatchingMediaItems(%d)", nonMatchingMediaItems.size()));
        for (MediaItem mediaItem2 : nonMatchingMediaItems) {
            mediaFile = new MediaFile(directory, mediaItem2.getFilename());
            mediaItemDescription = mediaItem2.getDescription();
            LoggerFactory.getLogger().finer(ResourceBundleFactory.msg("MediaItemFile(%s,%s,%s,%s)", mediaFile.getAbsolutePath(), "Missing", mediaItem2.getProductUrl(), mediaItemDescription));
            LoggerFactory.getLogger().warning(ResourceBundleFactory.msg("NonMatchingMediaItemAction(%s,%s)", mediaFile.getAbsolutePath(), mediaItem2.getProductUrl()));
        }
        LoggerFactory.getLogger().info(ResourceBundleFactory.msg("MissingMediaItems(%d)", mediaFilesOfMissingMediaItems.size()));
        for (MediaFile mediaFile2 : mediaFilesOfMissingMediaItems) {
            LoggerFactory.getLogger().finer(ResourceBundleFactory.msg("MediaItemFile(%s,%s,%s,%s)", mediaFile2.getAbsolutePath(), mediaFile2.generateDescription(), "Missing", "Missing"));
            LoggerFactory.getLogger().warning(ResourceBundleFactory.msg("MissingMediaItemAction(%s)", mediaFile2.getAbsolutePath()));
        }
        LoggerFactory.getLogger().info(ResourceBundleFactory.msg("UploadingMediaItems", new Object[0]));
        GPhotos.createMediaItems(photosLibraryClient, album, mediaFilesOfMissingMediaItems).forEach(mediaItem -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg("UploadedMediaItem(%s,%s)", mediaItem.getFilename(), mediaItem.getProductUrl())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AnsiConsole.systemInstall();
        LoggerFactory.init(GPhotosUploader.class.getCanonicalName());
        Handler ansiConsoleHandler = LoggerFactory.addAnsiConsoleHandler(LoggerFactory.loggingLevelForVerbosity(this.verbose.length - this.quiet.length));
        LoggerFactory.addFileHandler(LoggerFactory.tempLogFilePatternForName(GPhotosUploader.class.getCanonicalName()));
        try {
            String consoleLevelName;
            Properties configProperties = this.config.loadPropertiesFromConfigFileOrEmpty(this.configFile);
            if (this.verbose.length == 0 && this.quiet.length == 0 && (consoleLevelName = configProperties.getProperty(CONFIG_KEY_LOGGER_CONSOLE_LEVEL_NAME)) != null && !consoleLevelName.isEmpty()) {
                ansiConsoleHandler.setLevel(Level.parse(consoleLevelName));
            }
            if (this.credentialsProfiles == null) {
                this.runForCredentialsProfile(configProperties, null);
            } else {
                for (String credentialsProfile : this.credentialsProfiles) {
                    this.runForCredentialsProfile(configProperties, credentialsProfile);
                }
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("UnknownError(%s)", e.getMessage()), e);
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }

    private void runForCredentialsProfile(Properties configProperties, String credentialsProfile) throws IOException, GeneralSecurityException {
        String credentialsFile = this.config.getConfigFile(configProperties.getProperty(CONFIG_KEY_CREDENTIALS_FILE + (String)(credentialsProfile != null ? ".profile-" + credentialsProfile : ""), CREDENTIALS_FILE)).getAbsolutePath();
        String credentialsDirectory = this.config.getConfigFile(configProperties.getProperty(CONFIG_KEY_CREDENTIALS_DIRECTORY + (String)(credentialsProfile != null ? ".profile-" + credentialsProfile : ""), CREDENTIALS_DIRECTORY) + File.separator).getAbsolutePath();
        LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("ConnectingToGPhotos(%s)", Strings.nullToEmpty((String)credentialsProfile)));
        PhotosLibraryClient photosLibraryClient = PhotosLibraryClientFactory.createClient(credentialsFile, REQUIRED_SCOPES, new File(credentialsDirectory));
        boolean actionPerformed = false;
        if (this.listAlbums != null) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("ListingAlbums(%s)", this.listAlbums));
            this.listAlbums(photosLibraryClient, this.listAlbums);
            actionPerformed = true;
        }
        if (this.listSharedAlbums != null) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("ListingSharedAlbums(%s)", this.listSharedAlbums));
            this.listSharedAlbums(photosLibraryClient, this.listSharedAlbums);
            actionPerformed = true;
        }
        if (this.unshareAlbums != null) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("UnsharingAlbums(%s)", this.unshareAlbums));
            this.unshareAlbums(photosLibraryClient, this.unshareAlbums);
            actionPerformed = true;
        }
        if (this.shareAlbums != null) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("SharingAlbums(%s)", this.shareAlbums));
            this.shareAlbums(photosLibraryClient, this.shareAlbums, this.collaborativeSharing, this.commentableSharing);
            actionPerformed = true;
        }
        if (this.exportSharedAlbums != null) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("ExportingTokens(%s,%s)", this.exportSharedAlbums, this.importExportFile));
            this.exportShareTokens(photosLibraryClient, this.importExportFile, this.exportSharedAlbums);
            actionPerformed = true;
        }
        if (this.importShareTokens != null) {
            int tokensFromNo;
            int n = tokensFromNo = this.importShareTokens.length >= 2 ? this.importShareTokens[0] - 1 : 0;
            int tokensToNo = this.importShareTokens.length >= 2 ? this.importShareTokens[1] - 1 : (this.importShareTokens.length == 1 ? this.importShareTokens[0] - 1 : 0x7FFFFFFE);
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("ImportingTokens(%d,%d,%s)", tokensFromNo + 1, tokensToNo + 1, this.importExportFile));
            this.importShareTokens(photosLibraryClient, this.importExportFile, tokensFromNo, tokensToNo);
            actionPerformed = true;
        }
        if (this.leaveShareTokens) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("LeavingTokens(%s)", this.importExportFile));
            this.leaveShareTokens(photosLibraryClient, this.importExportFile);
            actionPerformed = true;
        }
        if (this.inputDirectories != null) {
            LoggerFactory.getLogger().fine(ResourceBundleFactory.msg("ScanningDirectories", new Object[0]));
            this.processMediaDirectories(photosLibraryClient, this.inputDirectories);
            actionPerformed = true;
        }
        if (!actionPerformed) {
            CommandLine.usage((Object)this, (PrintStream)System.out);
        }
    }

    private void shareAlbums(PhotosLibraryClient photosLibraryClient, String regexPattern, boolean isCollaborative, boolean isCommentable) {
        SharedAlbumOptions sharedAlbumOptions = SharedAlbumOptions.newBuilder().setIsCollaborative(isCollaborative).setIsCommentable(isCommentable).build();
        GPhotos.getAlbumsStreamByTitle(photosLibraryClient, regexPattern, true).sorted(Comparator.comparing(Album::getTitle)).flatMap(album -> {
            try {
                return Stream.of(Pair.of((Object)album, (Object)photosLibraryClient.shareAlbum(album.getId(), sharedAlbumOptions)));
            }
            catch (ApiException e) {
                LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("SkippingShare(%s,%s,%s)", album.getTitle(), album.getProductUrl(), e.getMessage()), e);
                return Stream.empty();
            }
        }).forEach(pair -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg("SharedAlbum(%s,%s)", ((Album)pair.getLeft()).getTitle(), ((ShareAlbumResponse)pair.getRight()).getShareInfo().getShareableUrl())));
    }

    private void unshareAlbums(PhotosLibraryClient photosLibraryClient, String regexPattern) {
        GPhotos.getSharedAlbumsStreamByTitle(photosLibraryClient, regexPattern, true).sorted(Comparator.comparing(Album::getTitle)).flatMap(album -> {
            try {
                return Stream.of(Pair.of((Object)album, (Object)photosLibraryClient.unshareAlbum(album.getId())));
            }
            catch (ApiException e) {
                LoggerFactory.getLogger().log(Level.SEVERE, ResourceBundleFactory.msg("SkippingUnshare(%s,%s,%s)", album.getTitle(), album.getProductUrl(), e.getMessage()), e);
                return Stream.empty();
            }
        }).forEach(pair -> LoggerFactory.getLogger().info(ResourceBundleFactory.msg("UnsharedAlbum(%s,%s)", ((Album)pair.getLeft()).getTitle(), ((Album)pair.getLeft()).getProductUrl())));
    }

    static class GradlePropertiesVersionProvider
    implements CommandLine.IVersionProvider {
        GradlePropertiesVersionProvider() {
        }

        public String[] getVersion() {
            String[] stringArray;
            String implementationTitle = GPhotosUploader.class.getPackage().getImplementationTitle();
            String implementationVersion = GPhotosUploader.class.getPackage().getImplementationVersion();
            if (implementationTitle != null && implementationVersion != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = implementationTitle + " version " + implementationVersion;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = GPhotosUploader.class.getName() + " version UNKNOWN (not in a jar file)";
            }
            return stringArray;
        }
    }
}

