/*
 * Decompiled with CFR 0.152.
 */
package com.google.photos.library.sample.factories;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.photos.library.v1.PhotosLibraryClient;
import com.google.photos.library.v1.PhotosLibrarySettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.List;

public class PhotosLibraryClientFactory {
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final int LOCAL_RECEIVER_PORT = 61984;

    private PhotosLibraryClientFactory() {
    }

    public static PhotosLibraryClient createClient(String credentialsPath, List<String> selectedScopes, File credentialsDataStoreDirectory) throws IOException, GeneralSecurityException {
        PhotosLibrarySettings settings = PhotosLibrarySettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)PhotosLibraryClientFactory.getUserCredentials(credentialsPath, selectedScopes, credentialsDataStoreDirectory))).build();
        return PhotosLibraryClient.initialize((PhotosLibrarySettings)settings);
    }

    private static Credentials getUserCredentials(String credentialsPath, List<String> selectedScopes, File credentialsDataStoreDirectory) throws IOException, GeneralSecurityException {
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(new FileInputStream(credentialsPath)));
        String clientId = clientSecrets.getDetails().getClientId();
        String clientSecret = clientSecrets.getDetails().getClientSecret();
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), JSON_FACTORY, clientSecrets, selectedScopes).setDataStoreFactory((DataStoreFactory)new FileDataStoreFactory(credentialsDataStoreDirectory)).setAccessType("offline").build();
        LocalServerReceiver receiver = new LocalServerReceiver.Builder().setPort(61984).build();
        Credential credential = new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)receiver).authorize("user");
        return UserCredentials.newBuilder().setClientId(clientId).setClientSecret(clientSecret).setRefreshToken(credential.getRefreshToken()).build();
    }
}

